package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.component.SequencedAssemblyJunk;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public interface ItemApplicationRecipe extends CreateRecipe<ItemApplicationInput> {
    class_1799 result();

    boolean keepHeldItem();

    class_1856 target();

    class_1856 ingredient();

    @Override
    default boolean matches(ItemApplicationInput input, class_1937 world) {
        return target().method_8093(input.target()) && ingredient().method_8093(input.ingredient());
    }

    @Override
    default class_1799 assemble(ItemApplicationInput input, class_7225.class_7874 registries) {
        SequencedAssemblyJunk junk = input.target().method_58694(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK);
        if (junk != null && junk.hasJunk()) {
            return junk.getJunk();
        }
        return result().method_7972();
    }

    record Serializer<T extends ItemApplicationRecipe>(
        MapCodec<T> codec, class_9139<class_9129, T> streamCodec
    ) implements class_1865<T> {
        public Serializer(Factory<T> factory) {
            this(
                RecordCodecBuilder.mapCodec(instance -> instance.group(
                    class_1799.field_24671.fieldOf("result").forGetter(ItemApplicationRecipe::result),
                    Codec.BOOL.optionalFieldOf("keep_held_item", false).forGetter(ItemApplicationRecipe::keepHeldItem),
                    class_1856.field_46095.fieldOf("target").forGetter(ItemApplicationRecipe::target),
                    class_1856.field_46095.fieldOf("ingredient").forGetter(ItemApplicationRecipe::ingredient)
                ).apply(instance, factory::create)), class_9139.method_56905(
                    class_1799.field_48349,
                    ItemApplicationRecipe::result,
                    class_9135.field_48547,
                    ItemApplicationRecipe::keepHeldItem,
                    class_1856.field_48355,
                    ItemApplicationRecipe::target,
                    class_1856.field_48355,
                    ItemApplicationRecipe::ingredient,
                    factory::create
                )
            );
        }

        public interface Factory<T extends ItemApplicationRecipe> {
            T create(class_1799 result, boolean keepHeldItem, class_1856 block, class_1856 item);
        }
    }
}
