package com.zurrtum.create.content.kinetics.drill;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInteractionRegistry;
import com.zurrtum.create.infrastructure.fluids.FluidInteractionRegistry.FluidInteraction;
import com.zurrtum.create.infrastructure.fluids.FluidInteractionRegistry.HasFluidInteraction;
import com.zurrtum.create.infrastructure.fluids.FluidInteractionRegistry.InteractionInformation;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class CobbleGenOptimisation {
    static CobbleGenLevel cachedLevel;

    public record CobbleGenBlockConfiguration(List<class_2680> statesAroundDrill) {
    }

    @Nullable
    public static CobbleGenBlockConfiguration getConfig(class_1936 level, class_2338 drillPos, class_2350 drillDirection) {
        List<class_2680> list = new ArrayList<>();
        for (class_2350 side : Iterate.directions) {
            class_2338 relative = drillPos.method_10093(drillDirection).method_10093(side);
            if (level instanceof class_1937 l && !l.method_8477(relative))
                return null;
            list.add(level.method_8320(relative));
        }
        return new CobbleGenBlockConfiguration(list);
    }

    public static class_2680 determineOutput(class_3218 level, class_2338 pos, CobbleGenBlockConfiguration config) {
        Map<class_3611, List<InteractionInformation>> interactions = FluidInteractionRegistry.INTERACTIONS;
        Map<class_3611, Pair<class_2350, class_3610>> presentFluidTypes = new HashMap<>();

        for (int i = 0; i < Iterate.directions.length; i++) {
            if (config.statesAroundDrill.size() <= i)
                break;
            class_3610 fluidState = config.statesAroundDrill.get(i).method_26227();
            if (!fluidState.method_15769()) {
                class_3611 fluid = fluidState.method_15772();
                if (interactions.get(fluid) != null)
                    presentFluidTypes.put(fluid, Pair.of(Iterate.directions[i], fluidState));
            }
        }

        FluidInteraction interaction = null;
        Pair<class_2350, class_3610> affected = null;

        Search:
        for (Map.Entry<class_3611, Pair<class_2350, class_3610>> type : presentFluidTypes.entrySet()) {
            List<InteractionInformation> list = interactions.get(type.getKey());
            class_3610 state = FluidHelper.convertToFlowing(type.getValue().getSecond().method_15772()).method_15785();

            if (list == null)
                continue;
            for (class_2350 d : Iterate.horizontalDirections) {
                for (InteractionInformation information : list) {
                    if (d == type.getValue().getFirst())
                        continue;
                    class_2338 relative = pos.method_10093(d);
                    HasFluidInteraction predicate = information.predicate();
                    if (!predicate.test(level, pos, relative, state))
                        continue;
                    interaction = information.interaction();
                    affected = Pair.of(d, state);
                    break Search;
                }
            }
        }

        class_3218 owLevel = level.method_8503().method_3847(class_1937.field_25179);
        if (owLevel == null)
            owLevel = level;

        if (cachedLevel == null || cachedLevel.getLevel() != owLevel)
            cachedLevel = new CobbleGenLevel(level);

        class_2680 result = class_2246.field_10124.method_9564();
        if (interaction == null)
            return result;

        interaction.interact(cachedLevel, pos, pos.method_10093(affected.getFirst()), affected.getSecond());
        class_2680 output = cachedLevel.blocksAdded.getOrDefault(pos, result);
        cachedLevel.clear();

        return output;
    }

    public static void invalidateWorld(class_1936 world) {
        if (cachedLevel != null && cachedLevel.getLevel() == world)
            cachedLevel = null;
    }
}
