package com.zurrtum.create.content.kinetics.fan;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.chute.ChuteBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public class EncasedFanBlockEntity extends KineticBlockEntity implements IAirCurrentSource {

    public AirCurrent airCurrent;
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow;

    public EncasedFanBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ENCASED_FAN, pos, state);
        airCurrent = new AirCurrent(this);
        updateAirFlow = true;
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.ENCASED_FAN, AllAdvancements.FAN_PROCESSING);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket)
            airCurrent.rebuild();
    }

    @Override
    public AirCurrent getAirCurrent() {
        return airCurrent;
    }

    @Nullable
    @Override
    public class_1937 getAirCurrentWorld() {
        return field_11863;
    }

    @Override
    public class_2338 getAirCurrentPos() {
        return field_11867;
    }

    @Override
    public class_2350 getAirflowOriginSide() {
        return method_11010().method_11654(EncasedFanBlock.FACING);
    }

    @Override
    public class_2350 getAirFlowDirection() {
        float speed = getSpeed();
        if (speed == 0)
            return null;
        class_2350 facing = method_11010().method_11654(class_2741.field_12525);
        speed = convertToDirection(speed, facing);
        return speed > 0 ? facing : facing.method_10153();
    }

    @Override
    public void remove() {
        super.remove();
        updateChute();
    }

    @Override
    public boolean isSourceRemoved() {
        return field_11865;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        updateAirFlow = true;
        updateChute();
    }

    public void updateChute() {
        class_2350 direction = method_11010().method_11654(EncasedFanBlock.FACING);
        if (!direction.method_10166().method_10178())
            return;
        class_2586 poweredChute = field_11863.method_8321(field_11867.method_10093(direction));
        if (!(poweredChute instanceof ChuteBlockEntity chuteBE))
            return;
        if (direction == class_2350.field_11033)
            chuteBE.updatePull();
        else
            chuteBE.updatePush(1);
    }

    public void blockInFrontChanged() {
        updateAirFlow = true;
    }

    @Override
    public void tick() {
        super.tick();

        boolean server = !field_11863.method_8608() || isVirtual();

        if (server && airCurrentUpdateCooldown-- <= 0) {
            airCurrentUpdateCooldown = AllConfigs.server().kinetics.fanBlockCheckRate.get();
            updateAirFlow = true;
        }

        if (updateAirFlow) {
            updateAirFlow = false;
            airCurrent.rebuild();
            if (airCurrent.maxDistance > 0)
                award(AllAdvancements.ENCASED_FAN);
            sendData();
        }

        if (getSpeed() == 0)
            return;

        if (entitySearchCooldown-- <= 0) {
            entitySearchCooldown = 5;
            airCurrent.findEntities();
        }

        airCurrent.tick();
    }

}