package com.zurrtum.create.content.kinetics.fan;

import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.config.CKinetics;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public interface IAirCurrentSource {
    @Nullable AirCurrent getAirCurrent();

    @Nullable class_1937 getAirCurrentWorld();

    class_2338 getAirCurrentPos();

    float getSpeed();

    class_2350 getAirflowOriginSide();

    @Nullable class_2350 getAirFlowDirection();

    default float getMaxDistance() {
        float speed = Math.abs(this.getSpeed());
        CKinetics config = AllConfigs.server().kinetics;
        float distanceFactor = Math.min(speed / config.fanRotationArgmax.get(), 1);
        float pushDistance = class_3532.method_48781(distanceFactor, 3, config.fanPushDistance.get());
        float pullDistance = class_3532.method_16439(distanceFactor, 3f, config.fanPullDistance.get());
        return this.getSpeed() > 0 ? pushDistance : pullDistance;
    }

    boolean isSourceRemoved();
}
