package com.zurrtum.create.content.kinetics.gantry;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class GantryShaftBlockEntity extends KineticBlockEntity {

    public GantryShaftBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.GANTRY_SHAFT, pos, state);
    }

    @Override
    protected boolean syncSequenceContext() {
        return true;
    }

    public void checkAttachedCarriageBlocks() {
        if (!canAssembleOn())
            return;
        for (class_2350 d : Iterate.directions) {
            if (d.method_10166() == method_11010().method_11654(GantryShaftBlock.FACING).method_10166())
                continue;
            class_2338 offset = field_11867.method_10093(d);
            class_2680 pinionState = field_11863.method_8320(offset);
            if (!pinionState.method_27852(AllBlocks.GANTRY_CARRIAGE))
                continue;
            if (pinionState.method_11654(GantryCarriageBlock.FACING) != d)
                continue;
            class_2586 blockEntity = field_11863.method_8321(offset);
            if (blockEntity instanceof GantryCarriageBlockEntity)
                ((GantryCarriageBlockEntity) blockEntity).queueAssembly();
        }
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        checkAttachedCarriageBlocks();
    }

    @Override
    public float propagateRotationTo(
        KineticBlockEntity target,
        class_2680 stateFrom,
        class_2680 stateTo,
        class_2338 diff,
        boolean connectedViaAxes,
        boolean connectedViaCogs
    ) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);

        if (connectedViaAxes)
            return defaultModifier;
        if (!stateFrom.method_11654(GantryShaftBlock.POWERED))
            return defaultModifier;
        if (!stateTo.method_27852(AllBlocks.GANTRY_CARRIAGE))
            return defaultModifier;

        class_2350 direction = class_2350.method_10147(diff.method_10263(), diff.method_10264(), diff.method_10260());
        if (stateTo.method_11654(GantryCarriageBlock.FACING) != direction)
            return defaultModifier;
        return GantryCarriageBlockEntity.getGantryPinionModifier(
            stateFrom.method_11654(GantryShaftBlock.FACING),
            stateTo.method_11654(GantryCarriageBlock.FACING)
        );
    }

    @Override
    public boolean isCustomConnection(KineticBlockEntity other, class_2680 state, class_2680 otherState) {
        if (!otherState.method_27852(AllBlocks.GANTRY_CARRIAGE))
            return false;
        final class_2338 diff = other.method_11016().method_10059(field_11867);
        class_2350 direction = class_2350.method_10147(diff.method_10263(), diff.method_10264(), diff.method_10260());
        return otherState.method_11654(GantryCarriageBlock.FACING) == direction;
    }

    public boolean canAssembleOn() {
        class_2680 blockState = method_11010();
        if (blockState.method_26204() != AllBlocks.GANTRY_SHAFT)
            return false;
        if (blockState.method_11654(GantryShaftBlock.POWERED))
            return false;
        float speed = getPinionMovementSpeed();

        switch (blockState.method_11654(GantryShaftBlock.PART)) {
            case END:
                return speed < 0;
            case MIDDLE:
                return speed != 0;
            case START:
                return speed > 0;
            case SINGLE:
            default:
                return false;
        }
    }

    public float getPinionMovementSpeed() {
        class_2680 blockState = method_11010();
        if (blockState.method_26204() != AllBlocks.GANTRY_SHAFT)
            return 0;
        return class_3532.method_15363(convertToLinear(-getSpeed()), -.49f, .49f);
    }

    @Override
    public boolean isNoisy() {
        return false;
    }

}
