package com.zurrtum.create.content.kinetics.gauge;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.foundation.block.IBE;

import java.util.Locale;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_5819;

public class GaugeBlock extends DirectionalAxisKineticBlock implements IBE<GaugeBlockEntity> {

    public static final GaugeShaper GAUGE = GaugeShaper.make();
    protected Type type;

    public enum Type implements class_3542 {
        SPEED,
        STRESS;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public static GaugeBlock speed(class_2251 properties) {
        return new GaugeBlock(properties, Type.SPEED);
    }

    public static GaugeBlock stress(class_2251 properties) {
        return new GaugeBlock(properties, Type.STRESS);
    }

    protected GaugeBlock(class_2251 properties, Type type) {
        super(properties);
        this.type = type;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2350 face = context.method_8038();
        class_2338 placedOnPos = context.method_8037().method_10093(context.method_8038().method_10153());
        class_2680 placedOnState = world.method_8320(placedOnPos);
        class_2248 block = placedOnState.method_26204();

        if (block instanceof IRotate iRotate && iRotate.hasShaftTowards(world, placedOnPos, placedOnState, face)) {
            class_2680 toPlace = method_9564();
            class_2350 horizontalFacing = context.method_8042();
            class_2350 nearestLookingDirection = context.method_7715();
            boolean lookPositive = nearestLookingDirection.method_10171() == class_2352.field_11056;
            if (face.method_10166() == class_2351.field_11048) {
                toPlace = toPlace.method_11657(FACING, lookPositive ? class_2350.field_11043 : class_2350.field_11035).method_11657(AXIS_ALONG_FIRST_COORDINATE, true);
            } else if (face.method_10166() == class_2351.field_11052) {
                toPlace = toPlace.method_11657(FACING, horizontalFacing.method_10153())
                    .method_11657(AXIS_ALONG_FIRST_COORDINATE, horizontalFacing.method_10166() == class_2351.field_11048);
            } else {
                toPlace = toPlace.method_11657(FACING, lookPositive ? class_2350.field_11039 : class_2350.field_11034).method_11657(AXIS_ALONG_FIRST_COORDINATE, false);
            }

            return toPlace;
        }

        return super.method_9605(context);
    }

    @Override
    protected class_2350 getFacingForPlacement(class_1750 context) {
        return context.method_8038();
    }

    @Override
    protected boolean getAxisAlignmentForPlacement(class_1750 context) {
        return context.method_8042().method_10166() != class_2351.field_11048;
    }

    public boolean shouldRenderHeadOnFace(class_1937 world, class_2338 pos, class_2680 state, class_2350 face) {
        if (face.method_10166().method_10178())
            return false;
        if (face == state.method_11654(FACING).method_10153())
            return false;
        if (face.method_10166() == getRotationAxis(state))
            return false;
        if (getRotationAxis(state) == class_2351.field_11052 && face != state.method_11654(FACING))
            return false;
        return class_2248.method_9607(state, world.method_8320(pos.method_10093(face)), face) || world instanceof WrappedLevel;
    }

    @Override
    public void method_9496(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_5819 rand) {
        class_2586 be = worldIn.method_8321(pos);
        if (!(be instanceof GaugeBlockEntity gaugeBE))
            return;
        if (gaugeBE.dialTarget == 0)
            return;
        int color = gaugeBE.color;

        for (class_2350 face : Iterate.directions) {
            if (!shouldRenderHeadOnFace(worldIn, pos, stateIn, face))
                continue;

            class_243 faceVec = class_243.method_24954(face.method_62675());
            class_2350 positiveFacing = class_2350.method_10156(class_2352.field_11056, face.method_10166());
            class_243 positiveFaceVec = class_243.method_24954(positiveFacing.method_62675());
            int particleCount = gaugeBE.dialTarget > 1 ? 4 : 1;

            if (particleCount == 1 && rand.method_43057() > 1 / 4f)
                continue;

            for (int i = 0; i < particleCount; i++) {
                class_243 mul = VecHelper.offsetRandomly(class_243.field_1353, rand, .25f).method_18806(new class_243(1, 1, 1).method_1020(positiveFaceVec)).method_1029()
                    .method_1021(.3f);
                class_243 offset = VecHelper.getCenterOf(pos).method_1019(faceVec.method_1021(.55)).method_1019(mul);
                worldIn.method_8406(new class_2390(color, 1), offset.field_1352, offset.field_1351, offset.field_1350, mul.field_1352, mul.field_1351, mul.field_1350);
            }

        }

    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return GAUGE.get(state.method_11654(FACING), state.method_11654(AXIS_ALONG_FIRST_COORDINATE));
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 blockState, class_1937 worldIn, class_2338 pos, class_2350 direction) {
        class_2586 be = worldIn.method_8321(pos);
        if (be instanceof GaugeBlockEntity gaugeBlockEntity) {
            return class_3532.method_15386(class_3532.method_15363(gaugeBlockEntity.dialTarget * 14, 0, 15));
        }
        return 0;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public Class<GaugeBlockEntity> getBlockEntityClass() {
        return GaugeBlockEntity.class;
    }

    @Override
    public class_2591<? extends GaugeBlockEntity> getBlockEntityType() {
        return type == Type.SPEED ? AllBlockEntityTypes.SPEEDOMETER : AllBlockEntityTypes.STRESSOMETER;
    }
}
