package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder.Instance;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidStack;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record MixingRecipe(
    class_1799 result, FluidStack fluidResult, HeatCondition heat, List<FluidIngredient> fluidIngredients, List<SizedIngredient> ingredients
) implements BasinRecipe {
    @Override
    public int getIngredientSize() {
        return fluidIngredients.size() + ingredients().size();
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return ingredients;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return fluidIngredients;
    }

    @Override
    public boolean matches(BasinInput input, class_1937 world) {
        if (!heat.testBlazeBurner(input.heat())) {
            return false;
        }
        List<class_1799> outputs = BasinRecipe.tryCraft(input, ingredients);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, fluidIngredients)) {
            return false;
        }
        if (!result.method_7960()) {
            outputs.add(result);
        }
        List<FluidStack> fluids = fluidResult.isEmpty() ? List.of() : List.of(fluidResult);
        return input.acceptOutputs(outputs, fluids, true);
    }

    @Override
    public boolean apply(BasinInput input) {
        if (!heat.testBlazeBurner(input.heat())) {
            return false;
        }
        Deque<Runnable> changes = new ArrayDeque<>();
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, ingredients, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, fluidIngredients, changes)) {
            return false;
        }
        if (!result.method_7960()) {
            outputs.add(result);
        }
        List<FluidStack> fluids = fluidResult.isEmpty() ? List.of() : List.of(fluidResult);
        if (!input.acceptOutputs(outputs, fluids, true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, fluids, false);
    }

    @Override
    public class_1865<MixingRecipe> method_8119() {
        return AllRecipeSerializers.MIXING;
    }

    @Override
    public class_3956<MixingRecipe> method_17716() {
        return AllRecipeTypes.MIXING;
    }

    public static class Serializer implements class_1865<MixingRecipe> {
        public static final MapCodec<MixingRecipe> CODEC = RecordCodecBuilder.mapCodec((Instance<MixingRecipe> instance) -> instance.group(
            class_1799.field_24671.optionalFieldOf("result", class_1799.field_8037).forGetter(MixingRecipe::result),
            FluidStack.CODEC.optionalFieldOf("fluid_result", FluidStack.EMPTY).forGetter(MixingRecipe::fluidResult),
            HeatCondition.CODEC.optionalFieldOf("heat_requirement", HeatCondition.NONE).forGetter(MixingRecipe::heat),
            FluidIngredient.CODEC.listOf(1, 2).optionalFieldOf("fluid_ingredients", List.of()).forGetter(MixingRecipe::fluidIngredients),
            SizedIngredient.getListCodec(1, 4).optionalFieldOf("ingredients", List.of()).forGetter(MixingRecipe::ingredients)
        ).apply(instance, MixingRecipe::new)).validate(recipe -> {
            if (recipe.result.method_7960() && recipe.fluidResult.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a result or a fluid result");
            } else if (recipe.fluidIngredients.isEmpty() && recipe.ingredients.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a ingredient or a fluid ingredient");
            }
            return DataResult.success(recipe);
        });
        private static final class_9139<class_9129, MixingRecipe> PACKET_CODEC = class_9139.method_56906(
            class_1799.field_49268,
            MixingRecipe::result,
            FluidStack.OPTIONAL_PACKET_CODEC,
            MixingRecipe::fluidResult,
            HeatCondition.PACKET_CODEC,
            MixingRecipe::heat,
            FluidIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()),
            MixingRecipe::fluidIngredients,
            SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()),
            MixingRecipe::ingredients,
            MixingRecipe::new
        );

        @Override
        public MapCodec<MixingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, MixingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}
