package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractShaftBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class PoweredShaftBlock extends AbstractShaftBlock {

    public PoweredShaftBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.EIGHT_VOXEL_POLE.get(pState.method_11654(AXIS));
    }

    @Override
    public class_2591<? extends KineticBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.POWERED_SHAFT;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player.method_5715() || !player.method_7294())
            return class_1269.field_52423;

        IPlacementHelper helper = PlacementHelpers.get(ShaftBlock.placementHelperId);
        if (helper.matchesItem(stack))
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);

        return class_1269.field_52423;
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        if (!stillValid(pState, pLevel, pPos))
            pLevel.method_8652(
                pPos,
                AllBlocks.SHAFT.method_9564().method_11657(ShaftBlock.AXIS, pState.method_11654(AXIS))
                    .method_11657(WATERLOGGED, pState.method_11654(WATERLOGGED)),
                class_2248.field_31036
            );
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.SHAFT.method_7854();
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return stillValid(pState, pLevel, pPos);
    }

    public static boolean stillValid(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        for (class_2350 d : Iterate.directions) {
            if (d.method_10166() == pState.method_11654(AXIS))
                continue;
            class_2338 enginePos = pPos.method_10079(d, 2);
            class_2680 engineState = pLevel.method_8320(enginePos);
            if (!(engineState.method_26204() instanceof SteamEngineBlock engine))
                continue;
            if (!SteamEngineBlock.getShaftPos(engineState, enginePos).equals(pPos))
                continue;
            if (SteamEngineBlock.isShaftValid(engineState, pState))
                return true;
        }
        return false;
    }

    public static class_2680 getEquivalent(class_2680 stateForPlacement) {
        return AllBlocks.POWERED_SHAFT.method_9564().method_11657(PoweredShaftBlock.AXIS, stateForPlacement.method_11654(ShaftBlock.AXIS))
            .method_11657(WATERLOGGED, stateForPlacement.method_11654(WATERLOGGED));
    }

}
