package com.zurrtum.create.content.kinetics.waterwheel;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class WaterWheelBlock extends DirectionalKineticBlock implements IBE<WaterWheelBlockEntity> {

    public WaterWheelBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        for (class_2350 direction : Iterate.directions) {
            class_2338 neighbourPos = pos.method_10093(direction);
            class_2680 neighbourState = worldIn.method_8320(neighbourPos);
            if (!neighbourState.method_27852(AllBlocks.WATER_WHEEL))
                continue;
            class_2351 axis = state.method_11654(FACING).method_10166();
            if (neighbourState.method_11654(FACING).method_10166() != axis || axis != direction.method_10166())
                return false;
        }
        return true;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        return onBlockEntityUseItemOn(level, pos, wwt -> wwt.applyMaterialIfValid(stack));
    }

    @Override
    public class_2680 method_9559(
        class_2680 stateIn,
        class_4538 worldIn,
        class_10225 tickView,
        class_2338 currentPos,
        class_2350 facing,
        class_2338 facingPos,
        class_2680 facingState,
        class_5819 random
    ) {
        if (worldIn instanceof WrappedLevel)
            return stateIn;
        if (worldIn.method_8608())
            return stateIn;
        if (!tickView.method_8397().method_8674(currentPos, this))
            tickView.method_64310(currentPos, this, 1);
        return stateIn;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, worldIn, pos, oldState, isMoving);
        if (worldIn.method_8608())
            return;
        if (!worldIn.method_8397().method_8674(pos, this))
            worldIn.method_64310(pos, this, 1);
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        withBlockEntityDo(pLevel, pPos, WaterWheelBlockEntity::determineAndApplyFlowScore);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        state.method_11657(FACING, class_2350.method_10156(class_2352.field_11056, state.method_11654(FACING).method_10166()));
        return state;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return state.method_11654(FACING).method_10166() == face.method_10166();
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(FACING).method_10166();
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1f;
    }

    @Override
    public boolean hideStressImpact() {
        return true;
    }

    @Override
    public Class<WaterWheelBlockEntity> getBlockEntityClass() {
        return WaterWheelBlockEntity.class;
    }

    @Override
    public class_2591<? extends WaterWheelBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.WATER_WHEEL;
    }
}
