package com.zurrtum.create.content.kinetics.waterwheel;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2258;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_6088;

public class WaterWheelBlockEntity extends GeneratingKineticBlockEntity {

    public static final Map<class_2351, Set<class_2338>> SMALL_OFFSETS = new EnumMap<>(class_2351.class);
    public static final Map<class_2351, Set<class_2338>> LARGE_OFFSETS = new EnumMap<>(class_2351.class);

    static {
        for (class_2351 axis : Iterate.axes) {
            HashSet<class_2338> offsets = new HashSet<>();
            for (class_2350 d : Iterate.directions)
                if (d.method_10166() != axis)
                    offsets.add(class_2338.field_10980.method_10093(d));
            SMALL_OFFSETS.put(axis, offsets);

            offsets = new HashSet<>();
            for (class_2350 d : Iterate.directions) {
                if (d.method_10166() == axis)
                    continue;
                class_2338 centralOffset = class_2338.field_10980.method_10079(d, 2);
                offsets.add(centralOffset);
                for (class_2350 d2 : Iterate.directions) {
                    if (d2.method_10166() == axis)
                        continue;
                    if (d2.method_10166() == d.method_10166())
                        continue;
                    offsets.add(centralOffset.method_10093(d2));
                }
            }
            LARGE_OFFSETS.put(axis, offsets);
        }
    }

    public int flowScore;
    public class_2680 material;

    public WaterWheelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        material = class_2246.field_9975.method_9564();
        setLazyTickRate(60);
    }

    public WaterWheelBlockEntity(class_2338 pos, class_2680 state) {
        this(AllBlockEntityTypes.WATER_WHEEL, pos, state);
    }

    protected int getSize() {
        return 1;
    }

    protected Set<class_2338> getOffsetsToCheck() {
        return (getSize() == 1 ? SMALL_OFFSETS : LARGE_OFFSETS).get(getAxis());
    }

    public class_1269 applyMaterialIfValid(class_1799 stack) {
        if (!(stack.method_7909() instanceof class_1747 blockItem))
            return class_1269.field_52423;
        class_2680 material = blockItem.method_7711().method_9564();
        if (material == this.material)
            return class_1269.field_52423;
        if (!material.method_26164(class_3481.field_15471))
            return class_1269.field_52423;
        if (field_11863.method_8608() && !isVirtual())
            return class_1269.field_5812;
        this.material = material;
        notifyUpdate();
        field_11863.method_20290(class_6088.field_31144, field_11867, class_2248.method_9507(material));
        return class_1269.field_5812;
    }

    protected class_2351 getAxis() {
        class_2351 axis = class_2351.field_11048;
        class_2680 blockState = method_11010();
        if (blockState.method_26204() instanceof IRotate irotate)
            axis = irotate.getRotationAxis(blockState);
        return axis;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();

        // Water can change flow direction without notifying neighbours
        determineAndApplyFlowScore();
    }

    public void determineAndApplyFlowScore() {
        class_243 wheelPlane = class_243.method_24954(new class_2382(1, 1, 1).method_35852(class_2350.method_10156(class_2352.field_11056, getAxis()).method_62675()));

        int flowScore = 0;
        boolean lava = false;
        for (class_2338 blockPos : getOffsetsToCheck()) {
            class_2338 targetPos = blockPos.method_10081(field_11867);
            class_243 flowAtPos = getFlowVectorAtPosition(targetPos).method_18806(wheelPlane);
            lava |= FluidHelper.isLava(field_11863.method_8316(targetPos).method_15772());

            if (flowAtPos.method_1027() == 0)
                continue;

            flowAtPos = flowAtPos.method_1029();
            class_243 normal = class_243.method_24954(blockPos).method_1029();

            class_243 positiveMotion = VecHelper.rotate(normal, 90, getAxis());
            double dot = flowAtPos.method_1026(positiveMotion);
            if (Math.abs(dot) > .5)
                flowScore += Math.signum(dot);
        }

        if (flowScore != 0 && !field_11863.method_8608())
            award(lava ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);

        setFlowScoreAndUpdate(flowScore);
    }

    public class_243 getFlowVectorAtPosition(class_2338 pos) {
        class_3610 fluid = field_11863.method_8316(pos);
        class_243 vec = fluid.method_15758(field_11863, pos);
        class_2680 blockState = field_11863.method_8320(pos);
        if (blockState.method_26204() == class_2246.field_10422)
            vec = new class_243(0, blockState.method_11654(class_2258.field_10680) ? -1 : 1, 0);
        return vec;
    }

    public void setFlowScoreAndUpdate(int score) {
        if (flowScore == score)
            return;
        flowScore = score;
        updateGeneratedRotation();
        method_5431();
    }

    private void redraw() {
        if (!isVirtual())
            AllClientHandle.INSTANCE.queueUpdate(this);
        if (method_11002()) {
            field_11863.method_8413(method_11016(), method_11010(), method_11010(), 16);
            field_11863.method_8398().method_12130().method_15513(field_11867);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.LAVA_WHEEL, AllAdvancements.WATER_WHEEL);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        flowScore = view.method_71424("FlowScore", 0);

        class_2680 prevMaterial = this.material;
        Optional<class_2680> material = view.method_71426("Material", class_2680.field_24734);
        if (material.isEmpty())
            return;

        this.material = material.get();
        if (this.material.method_26215())
            this.material = class_2246.field_9975.method_9564();

        if (clientPacket && prevMaterial != this.material)
            redraw();
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71468("Material", class_2680.field_24734, material);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("FlowScore", flowScore);
        view.method_71468("Material", class_2680.field_24734, material);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1014(getSize());
    }

    @Override
    public float getGeneratedSpeed() {
        return class_3532.method_15340(flowScore, -1, 1) * 8 / getSize();
    }

}
