package com.zurrtum.create.content.logistics.chute;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6088;
import net.minecraft.util.*;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ChuteBlock extends AbstractChuteBlock implements ProperWaterloggedBlock {

    public static final class_2754<Shape> SHAPE = class_2754.method_11850("shape", Shape.class);
    public static final class_2754<class_2350> FACING = class_2741.field_12545;

    public ChuteBlock(class_2251 p_i48440_1_) {
        super(p_i48440_1_);
        method_9590(method_9564().method_11657(SHAPE, Shape.NORMAL).method_11657(FACING, class_2350.field_11033).method_11657(WATERLOGGED, false));
    }

    public enum Shape implements class_3542 {
        INTERSECTION,
        WINDOW,
        NORMAL,
        ENCASED;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    @Override
    public class_2350 getFacing(class_2680 state) {
        return state.method_11654(FACING);
    }

    @Override
    public boolean isOpen(class_2680 state) {
        return state.method_11654(FACING) == class_2350.field_11033 || state.method_11654(SHAPE) == Shape.INTERSECTION;
    }

    @Override
    public boolean method_9579(class_2680 state) {
        return state.method_11654(SHAPE) == Shape.WINDOW;
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        Shape shape = state.method_11654(SHAPE);
        boolean down = state.method_11654(FACING) == class_2350.field_11033;
        if (shape == Shape.INTERSECTION)
            return class_1269.field_5811;
        class_1937 level = context.method_8045();
        if (level.method_8608())
            return class_1269.field_5812;
        if (shape == Shape.ENCASED) {
            level.method_8501(context.method_8037(), state.method_11657(SHAPE, Shape.NORMAL));
            level.method_20290(
                class_6088.field_31144,
                context.method_8037(),
                class_2248.method_9507(AllBlocks.INDUSTRIAL_IRON_BLOCK.method_9564())
            );
            return class_1269.field_5812;
        }
        if (down)
            level.method_8501(context.method_8037(), state.method_11657(SHAPE, shape != Shape.NORMAL ? Shape.NORMAL : Shape.WINDOW));
        return class_1269.field_5812;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        Shape shape = state.method_11654(SHAPE);
        if (!stack.method_31574(AllItems.INDUSTRIAL_IRON_BLOCK))
            return super.method_55765(stack, state, level, pos, player, hand, hitResult);
        if (shape == Shape.INTERSECTION || shape == Shape.ENCASED)
            return super.method_55765(stack, state, level, pos, player, hand, hitResult);
        if (player == null || level.method_8608())
            return class_1269.field_5812;

        level.method_8501(pos, state.method_11657(SHAPE, Shape.ENCASED));
        level.method_8396(null, pos, class_3417.field_21922, class_3419.field_15245, 0.5f, 1.05f);
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = withWater(super.method_9605(ctx), ctx);
        class_2350 face = ctx.method_8038();
        if (face.method_10166().method_10179() && !ctx.method_8046()) {
            class_1937 world = ctx.method_8045();
            class_2338 pos = ctx.method_8037();
            return updateChuteState(state.method_11657(FACING, face), world.method_8320(pos.method_10084()), world, pos);
        }
        return state;
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 p_196271_6_,
        class_2680 above,
        class_5819 random
    ) {
        updateWater(world, tickView, state, pos);
        return super.method_9559(state, world, tickView, pos, direction, p_196271_6_, above, random);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> p_206840_1_) {
        super.method_9515(p_206840_1_.method_11667(SHAPE, FACING, WATERLOGGED));
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 above = world.method_8320(pos.method_10084());
        return !isChute(above) || getChuteFacing(above) == class_2350.field_11033;
    }

    @Override
    public class_2680 updateChuteState(class_2680 state, class_2680 above, class_1922 world, class_2338 pos) {
        if (!(state.method_26204() instanceof ChuteBlock))
            return state;

        Map<class_2350, Boolean> connections = new HashMap<>();
        int amtConnections = 0;
        class_2350 facing = state.method_11654(FACING);
        boolean vertical = facing == class_2350.field_11033;

        if (!vertical) {
            class_2680 target = world.method_8320(pos.method_10074().method_10093(facing.method_10153()));
            if (!isChute(target))
                return state.method_11657(FACING, class_2350.field_11033).method_11657(SHAPE, Shape.NORMAL);
        }

        for (class_2350 direction : Iterate.horizontalDirections) {
            class_2680 diagonalInputChute = world.method_8320(pos.method_10084().method_10093(direction));
            boolean value = diagonalInputChute.method_26204() instanceof ChuteBlock && diagonalInputChute.method_11654(FACING) == direction;
            connections.put(direction, value);
            if (value)
                amtConnections++;
        }

        boolean noConnections = amtConnections == 0;
        if (vertical)
            return state.method_11657(
                SHAPE,
                noConnections ? state.method_11654(SHAPE) == Shape.INTERSECTION ? Shape.NORMAL : state.method_11654(SHAPE) : Shape.INTERSECTION
            );
        if (noConnections)
            return state.method_11657(SHAPE, Shape.INTERSECTION);
        if (connections.get(class_2350.field_11043) && connections.get(class_2350.field_11035))
            return state.method_11657(SHAPE, Shape.INTERSECTION);
        if (connections.get(class_2350.field_11034) && connections.get(class_2350.field_11039))
            return state.method_11657(SHAPE, Shape.INTERSECTION);
        if (amtConnections == 1 && connections.get(facing) && !(getChuteFacing(above) == class_2350.field_11033) && !(above.method_26204() instanceof FunnelBlock && FunnelBlock.getFunnelFacing(
            above) == class_2350.field_11033))
            return state.method_11657(SHAPE, state.method_11654(SHAPE) == Shape.ENCASED ? Shape.ENCASED : Shape.NORMAL);
        return state.method_11657(SHAPE, Shape.INTERSECTION);
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return pState.method_11657(FACING, pRot.method_10503(pState.method_11654(FACING)));
    }

    @Override
    @SuppressWarnings("deprecation")
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345(pState.method_11654(FACING)));
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public class_2591<? extends ChuteBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CHUTE;
    }

}
