package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour.ProcessingResult;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class DepotBehaviour extends BlockEntityBehaviour<SmartBlockEntity> {

    public static final BehaviourType<DepotBehaviour> TYPE = new BehaviourType<>();

    public TransportedItemStack heldItem;
    public List<TransportedItemStack> incoming;
    public DepotOutputHandler processingOutputBuffer;
    public DepotItemHandler itemHandler;
    TransportedItemStackHandlerBehaviour transportedHandler;
    Supplier<Integer> maxStackSize;
    Supplier<Boolean> canAcceptItems;
    Predicate<class_2350> canFunnelsPullFrom;
    Consumer<class_1799> onHeldInserted;
    Predicate<class_1799> acceptedItems;
    boolean allowMerge;

    public DepotBehaviour(SmartBlockEntity be) {
        super(be);
        maxStackSize = () -> heldItem != null ? heldItem.stack.method_7914() : 64;
        canAcceptItems = () -> true;
        canFunnelsPullFrom = $ -> true;
        acceptedItems = $ -> true;
        onHeldInserted = $ -> {
        };
        incoming = new ArrayList<>();
        itemHandler = new DepotItemHandler(this);
        processingOutputBuffer = new DepotOutputHandler();
    }

    public void enableMerging() {
        allowMerge = true;
    }

    public DepotBehaviour withCallback(Consumer<class_1799> changeListener) {
        onHeldInserted = changeListener;
        return this;
    }

    public DepotBehaviour onlyAccepts(Predicate<class_1799> filter) {
        acceptedItems = filter;
        return this;
    }

    @Override
    public void tick() {
        super.tick();

        class_1937 world = blockEntity.method_10997();

        for (Iterator<TransportedItemStack> iterator = incoming.iterator(); iterator.hasNext(); ) {
            TransportedItemStack ts = iterator.next();
            if (!tick(ts))
                continue;
            if (world.method_8608() && !blockEntity.isVirtual())
                continue;
            if (heldItem == null) {
                heldItem = ts;
            } else {
                if (!ItemHelper.canItemStackAmountsStack(heldItem.stack, ts.stack)) {
                    class_243 vec = VecHelper.getCenterOf(blockEntity.method_11016());
                    class_1264.method_5449(blockEntity.method_10997(), vec.field_1352, vec.field_1351 + .5f, vec.field_1350, ts.stack);
                } else {
                    heldItem.stack.method_7933(ts.stack.method_7947());
                }
            }
            iterator.remove();
            blockEntity.notifyUpdate();
        }

        if (heldItem == null)
            return;
        if (!tick(heldItem))
            return;

        class_2338 pos = blockEntity.method_11016();

        if (world.method_8608())
            return;
        if (handleBeltFunnelOutput())
            return;

        BeltProcessingBehaviour processingBehaviour = BlockEntityBehaviour.get(world, pos.method_10086(2), BeltProcessingBehaviour.TYPE);
        if (processingBehaviour == null)
            return;
        if (!heldItem.locked && BeltProcessingBehaviour.isBlocked(world, pos))
            return;

        class_1799 previousItem = heldItem.stack;
        boolean wasLocked = heldItem.locked;
        ProcessingResult result = wasLocked ? processingBehaviour.handleHeldItem(
            heldItem,
            transportedHandler
        ) : processingBehaviour.handleReceivedItem(heldItem, transportedHandler);
        if (result == ProcessingResult.REMOVE) {
            heldItem = null;
            blockEntity.sendData();
            return;
        }

        heldItem.locked = result == ProcessingResult.HOLD;
        if (heldItem.locked != wasLocked || !class_1799.method_7973(previousItem, heldItem.stack))
            blockEntity.sendData();
    }

    protected boolean tick(TransportedItemStack heldItem) {
        heldItem.prevSideOffset = heldItem.sideOffset;
        if (heldItem.beltPosition == .5f) {
            return true;
        }
        heldItem.prevBeltPosition = heldItem.beltPosition;
        float diff = .5f - heldItem.beltPosition;
        if (diff > 1 / 512f) {
            if (diff > 1 / 32f && !BeltHelper.isItemUpright(heldItem.stack))
                heldItem.angle += 1;
            heldItem.beltPosition += diff / 4f;
        } else {
            heldItem.prevBeltPosition = heldItem.beltPosition = .5f;
        }
        return diff < 1 / 16f;
    }

    private boolean handleBeltFunnelOutput() {
        class_2680 funnel = getLevel().method_8320(getPos().method_10084());
        class_2350 funnelFacing = AbstractFunnelBlock.getFunnelFacing(funnel);
        if (funnelFacing == null || !canFunnelsPullFrom.test(funnelFacing.method_10153()))
            return false;

        for (int slot = 0; slot < processingOutputBuffer.method_5439(); slot++) {
            class_1799 previousItem = processingOutputBuffer.method_5438(slot);
            if (previousItem.method_7960())
                continue;
            class_1799 afterInsert = blockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
            if (afterInsert == null)
                return false;
            if (previousItem.method_7947() != afterInsert.method_7947()) {
                processingOutputBuffer.method_5447(slot, afterInsert);
                blockEntity.notifyUpdate();
                return true;
            }
        }

        class_1799 previousItem = heldItem.stack;
        class_1799 afterInsert = blockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
        if (afterInsert == null)
            return false;
        if (previousItem.method_7947() != afterInsert.method_7947()) {
            if (afterInsert.method_7960())
                heldItem = null;
            else
                heldItem.stack = afterInsert;
            blockEntity.notifyUpdate();
            return true;
        }

        return false;
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1937 level = getLevel();
        class_2338 pos = getPos();
        class_1264.method_5451(level, pos, processingOutputBuffer);
        for (TransportedItemStack transportedItemStack : incoming)
            class_2248.method_9577(level, pos, transportedItemStack.stack);
        if (!getHeldItemStack().method_7960())
            class_2248.method_9577(level, pos, getHeldItemStack());
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (heldItem != null)
            view.method_71468("HeldItem", TransportedItemStack.CODEC, heldItem);
        processingOutputBuffer.write(view);
        if (canMergeItems() && !incoming.isEmpty())
            view.method_71468("Incoming", CreateCodecs.TRANSPORTED_ITEM_LIST_CODEC, incoming);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        heldItem = view.method_71426("HeldItem", TransportedItemStack.CODEC).orElse(null);
        processingOutputBuffer.read(view);
        if (canMergeItems()) {
            incoming.clear();
            view.method_71426("Incoming", CreateCodecs.TRANSPORTED_ITEM_LIST_CODEC).ifPresent(incoming::addAll);
        }
    }

    public void addSubBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(blockEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide)
            .considerOccupiedWhen(this::isOccupied));
        transportedHandler = new TransportedItemStackHandlerBehaviour(
            blockEntity,
            this::applyToAllItems
        ).withStackPlacement(this::getWorldPositionOf);
        behaviours.add(transportedHandler);
    }

    public class_1799 getHeldItemStack() {
        return heldItem == null ? class_1799.field_8037 : heldItem.stack;
    }

    public boolean canMergeItems() {
        return allowMerge;
    }

    public int getPresentStackSize() {
        int cumulativeStackSize = 0;
        cumulativeStackSize += getHeldItemStack().method_7947();
        for (int slot = 0; slot < processingOutputBuffer.method_5439(); slot++)
            cumulativeStackSize += processingOutputBuffer.method_5438(slot).method_7947();
        return cumulativeStackSize;
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = getPresentStackSize();
        for (TransportedItemStack transportedItemStack : incoming)
            cumulativeStackSize += transportedItemStack.stack.method_7947();
        int fromGetter = Math.min(maxStackSize.get() == 0 ? 64 : maxStackSize.get(), getHeldItemStack().method_7914());
        return (fromGetter) - cumulativeStackSize;
    }

    public class_1799 insert(TransportedItemStack heldItem, boolean simulate) {
        if (!canAcceptItems.get())
            return heldItem.stack;
        if (!acceptedItems.test(heldItem.stack))
            return heldItem.stack;

        if (canMergeItems()) {
            int remainingSpace = getRemainingSpace();
            class_1799 inserted = heldItem.stack;
            if (remainingSpace <= 0)
                return inserted;
            if (this.heldItem != null && !ItemHelper.canItemStackAmountsStack(this.heldItem.stack, inserted))
                return inserted;

            class_1799 returned = class_1799.field_8037;
            if (remainingSpace < inserted.method_7947()) {
                returned = heldItem.stack.method_46651(inserted.method_7947() - remainingSpace);
                if (!simulate) {
                    TransportedItemStack copy = heldItem.copy();
                    copy.stack.method_7939(remainingSpace);
                    if (this.heldItem != null)
                        incoming.add(copy);
                    else
                        this.heldItem = copy;
                }
            } else {
                if (!simulate) {
                    if (this.heldItem != null)
                        incoming.add(heldItem);
                    else
                        this.heldItem = heldItem;
                }
            }
            return returned;
        }

        class_1799 returned = class_1799.field_8037;
        int maxCount = heldItem.stack.method_7914();
        boolean stackTooLarge = maxCount < heldItem.stack.method_7947();
        if (stackTooLarge)
            returned = heldItem.stack.method_46651(heldItem.stack.method_7947() - maxCount);

        if (simulate)
            return returned;

        if (this.isEmpty()) {
            if (heldItem.insertedFrom.method_10166().method_10179())
                AllSoundEvents.DEPOT_SLIDE.playOnServer(getLevel(), getPos());
            else
                AllSoundEvents.DEPOT_PLOP.playOnServer(getLevel(), getPos());
        }

        if (stackTooLarge) {
            heldItem = heldItem.copy();
            heldItem.stack.method_7939(maxCount);
        }

        this.heldItem = heldItem;
        onHeldInserted.accept(heldItem.stack);
        return returned;
    }

    public void setHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public void removeHeldItem() {
        this.heldItem = null;
    }

    public void setCenteredHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
        this.heldItem.beltPosition = 0.5f;
        this.heldItem.prevBeltPosition = 0.5f;
    }

    private boolean isOccupied(class_2350 side) {
        if (!getHeldItemStack().method_7960() && !canMergeItems())
            return true;
        if (!isOutputEmpty() && !canMergeItems())
            return true;
        if (!canAcceptItems.get())
            return true;
        return false;
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;

        if (isOccupied(side))
            return inserted;

        int size = transportedStack.stack.method_7947();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.method_10166().method_10178() ? .5f : 0;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        class_1799 remainder = insert(transportedStack, simulate);
        if (remainder.method_7947() != size)
            blockEntity.notifyUpdate();

        return remainder;
    }

    private void applyToAllItems(float maxDistanceFromCentre, Function<TransportedItemStack, TransportedResult> processFunction) {
        if (heldItem == null)
            return;
        if (.5f - heldItem.beltPosition > maxDistanceFromCentre)
            return;

        TransportedItemStack transportedItemStack = heldItem;
        class_1799 stackBefore = transportedItemStack.stack.method_7972();
        TransportedResult result = processFunction.apply(transportedItemStack);
        if (result == null || result.didntChangeFrom(stackBefore))
            return;

        heldItem = null;
        if (result.hasHeldOutput())
            setCenteredHeldItem(result.getHeldOutput());

        List<TransportedItemStack> outputs = result.getOutputs();
        if (!outputs.isEmpty()) {
            int skip = 0;
            if (getHeldItemStack().method_7960()) {
                setCenteredHeldItem(outputs.getFirst());
                skip = 1;
            }
            List<class_1799> items = outputs.stream().skip(skip).map(t -> t.stack).toList();
            items = processingOutputBuffer.insert(items);
            if (!items.isEmpty()) {
                class_1937 world = blockEntity.method_10997();
                class_243 vec = VecHelper.getCenterOf(blockEntity.method_11016()).method_1031(0, .5f, 0);
                double x = vec.field_1352;
                double y = vec.field_1351 + .5f;
                double z = vec.field_1350;
                for (class_1799 stack : items) {
                    class_1264.method_5449(world, x, y, z, stack);
                }
            }
        }

        blockEntity.notifyUpdate();
    }

    public boolean isEmpty() {
        return heldItem == null && isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        return processingOutputBuffer.method_5442();
    }

    private class_243 getWorldPositionOf(TransportedItemStack transported) {
        return VecHelper.getCenterOf(blockEntity.method_11016());
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isItemValid(class_1799 stack) {
        return acceptedItems.test(stack);
    }

    public class DepotOutputHandler implements ItemInventory {
        private final class_2371<class_1799> stacks;

        public DepotOutputHandler() {
            this.stacks = class_2371.method_10213(8, class_1799.field_8037);
        }

        @Override
        public int method_5439() {
            return 8;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot >= method_5439()) {
                return class_1799.field_8037;
            }
            return stacks.get(slot);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            stacks.set(slot, stack);
        }

        @Override
        public void method_5431() {
            blockEntity.notifyUpdate();
        }

        public void write(class_11372 view) {
            class_11372.class_11373<class_1799> list = view.method_71467("Inventory", class_1799.field_24671);
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) {
                    continue;
                }
                list.method_71484(stack);
            }
        }

        public void read(class_11368 view) {
            class_11368.class_11369<class_1799> list = view.method_71437("Inventory", class_1799.field_24671);
            int i = 0;
            for (class_1799 itemStack : list) {
                stacks.set(i++, itemStack);
            }
            for (int size = stacks.size(); i < size; i++) {
                stacks.set(i, class_1799.field_8037);
            }
        }
    }
}
