package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.EjectorItemSpawnPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class EjectorItemEntity extends class_1542 {
    private boolean alive;
    public EntityLauncher launcher;
    public class_2350 direction;
    @Nullable
    public Pair<class_243, class_2338> earlyTarget;
    public float earlyTargetTime;
    public int progress;
    public RenderData data;

    public EjectorItemEntity(class_1937 world, EjectorBlockEntity ejector, class_1799 stack) {
        super(AllEntityTypes.EJECTOR_ITEM, world);
        class_2338 pos = ejector.method_11016();
        method_5814(pos.method_10263() + 0.5f, pos.method_10264() + 0.5f, pos.method_10260() + 0.5f);
        method_6979(stack);
        if (method_73183().method_8608()) {
            data = new RenderData();
        }
        loadLauncher(ejector);
    }

    public EjectorItemEntity(class_1299<? extends EjectorItemEntity> type, class_1937 world) {
        super(type, world);
        if (method_73183().method_8608()) {
            data = new RenderData();
        }
    }

    @Override
    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new EjectorItemSpawnPacket(this, entityTrackerEntry);
    }

    @Override
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        EjectorItemSpawnPacket spawnPacket = (EjectorItemSpawnPacket) packet;
        alive = spawnPacket.getAlive();
        progress = spawnPacket.getProgress();
        if (!alive) {
            if (method_73183().method_8321(method_24515()) instanceof EjectorBlockEntity ejector) {
                loadLauncher(ejector);
                return;
            }
            if (spawnPacket.hasLauncher()) {
                launcher = spawnPacket.getLauncher();
                direction = spawnPacket.getDirection();
                data.calcRotate(direction.method_10153());
            } else {
                alive = true;
            }
        }
    }

    private void loadLauncher(EjectorBlockEntity ejector) {
        launcher = ejector.launcher;
        class_2350 facing = ejector.getFacing();
        direction = facing.method_10153();
        if (method_73183().method_8608()) {
            data.calcRotate(facing);
        }
    }

    @Override
    public void method_5652(class_11372 view) {
        view.method_71472("Alive", alive);
        view.method_71465("Progress", progress);
        if (!alive && !(method_73183().method_8321(method_24515()) instanceof EjectorBlockEntity)) {
            view.method_71468("Launcher", EntityLauncher.CODEC, launcher);
            view.method_71468("Direction", class_2350.field_29502, direction);
        }
        super.method_5652(view);
    }

    @Override
    public void method_5749(class_11368 view) {
        alive = view.method_71433("Alive", false);
        progress = view.method_71424("Progress", 0);
        if (!alive) {
            if (method_73183().method_8321(method_24515()) instanceof EjectorBlockEntity ejector) {
                loadLauncher(ejector);
            } else {
                view.method_71426("Launcher", EntityLauncher.CODEC).ifPresentOrElse(this::setLauncher, this::setIsAlive);
                view.method_71426("Direction", class_2350.field_29502).ifPresentOrElse(this::setDirection, this::setIsAlive);
                if (!alive && direction != null && method_73183().method_8608()) {
                    data.calcRotate(direction.method_10153());
                }
            }
        }
        super.method_5749(view);
    }

    private void setLauncher(EntityLauncher launcher) {
        this.launcher = launcher;
    }

    private void setDirection(class_2350 direction) {
        this.direction = direction;
    }

    private void setIsAlive() {
        this.alive = true;
    }

    @Override
    public boolean method_5805() {
        return alive;
    }

    @Override
    public void method_5694(class_1657 player) {
        if (alive) {
            super.method_5694(player);
        }
    }

    @Override
    public void method_5773() {
        boolean isClient = method_73183().method_8608();
        if (alive) {
            if (isClient) {
                data.tick();
            }
            super.method_5773();
            return;
        }
        boolean hit = scanTrajectoryForObstacles(isClient, progress + 1);
        float totalTime = Math.max(3, (float) launcher.getTotalFlyingTicks());
        if (hit) {
            placeItemAtTarget(isClient, Math.min(earlyTargetTime, totalTime));
            return;
        }
        if (progress + 2 >= totalTime) {
            if (isClient) {
                data.calcAnimateOffset(totalTime);
            }
            placeItemAtTarget(isClient, totalTime);
            return;
        }
        progress++;
    }

    private void placeItemAtTarget(boolean isClient, float maxTime) {
        DirectBeltInputBehaviour targetOpenInv = getTargetOpenInv();
        if (targetOpenInv != null) {
            class_1799 remainder = targetOpenInv.handleInsertion(method_6983(), class_2350.field_11036, isClient);
            if (remainder.method_7960()) {
                method_31472();
                return;
            }
            method_6979(remainder);
        }
        alive = true;
        class_243 ejectVec = earlyTarget != null ? earlyTarget.getFirst() : getLaunchedItemLocation(maxTime);
        class_243 ejectMotionVec = getLaunchedItemMotion(maxTime);
        method_5814(ejectVec.field_1352, ejectVec.field_1351, ejectVec.field_1350);
        method_63613();
        method_18799(ejectMotionVec);
    }

    private DirectBeltInputBehaviour getTargetOpenInv() {
        class_2338 targetPos = earlyTarget != null ? earlyTarget.getSecond() : method_24515().method_10086(launcher.getVerticalDistance())
            .method_10079(method_58149(), Math.max(1, launcher.getHorizontalDistance()));
        return BlockEntityBehaviour.get(method_73183(), targetPos, DirectBeltInputBehaviour.TYPE);
    }

    private boolean scanTrajectoryForObstacles(boolean isClient, float time) {
        class_243 source = getLaunchedItemLocation(time);
        class_243 target = getLaunchedItemLocation(time + 1);
        if (isClient) {
            data.calcRenderBox(source, target);
        }

        class_1937 world = method_73183();
        class_3965 rayTraceBlocks = world.method_17742(new class_3959(
            source,
            target,
            class_3959.class_3960.field_17558,
            class_3959.class_242.field_1348,
            class_3726.method_16194()
        ));
        boolean miss = rayTraceBlocks.method_17783() == class_239.class_240.field_1333;

        if (!miss && rayTraceBlocks.method_17783() == class_239.class_240.field_1332) {
            class_2680 blockState = world.method_8320(rayTraceBlocks.method_17777());
            if (FunnelBlock.isFunnel(blockState) && blockState.method_28498(FunnelBlock.EXTRACTING) && blockState.method_11654(FunnelBlock.EXTRACTING))
                miss = true;
        }

        if (miss) {
            if (earlyTarget != null && earlyTargetTime < time + 1) {
                earlyTarget = null;
                earlyTargetTime = 0;
            }
            return false;
        }

        class_243 vec = rayTraceBlocks.method_17784();
        earlyTarget = Pair.of(vec.method_1019(class_243.method_24954(rayTraceBlocks.method_17780().method_62675()).method_1021(.25f)), rayTraceBlocks.method_17777());
        earlyTargetTime = (float) (time + (source.method_1022(vec) / source.method_1022(target)));
        return true;
    }

    public class_243 getLaunchedItemLocation(float time) {
        return launcher.getGlobalPos(time, direction, method_73189());
    }

    public class_243 getLaunchedItemMotion(float time) {
        return launcher.getGlobalVelocity(time, direction).method_1021(.5f);
    }

    @Override
    public void method_66246(class_243 pos, float yaw, float pitch) {
    }

    public class RenderData {
        public float rotateY;
        public class_238 renderBox = method_5829();
        public int initAge = -1;
        public float animateOffset = -0.125f;

        public void calcRotate(class_2350 facing) {
            rotateY = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
        }

        public void calcRenderBox(class_243 source, class_243 target) {
            renderBox = new class_238(source.field_1352 - 1, source.field_1351 - 1, source.field_1350 - 1, target.field_1352, target.field_1351, target.field_1350);
        }

        public void calcAnimateOffset(float totalTime) {
            animateOffset += (totalTime - progress - 1) / 4;
        }

        public void tick() {
            if (initAge == -1) {
                if (method_24828()) {
                    initAge = field_6012;
                }
            } else if (animateOffset < 0) {
                animateOffset = Math.min(animateOffset + 0.005f, 0);
            }
        }
    }
}