package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.storage.DepotMountedStorage;

import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class MountedDepotInteractionBehaviour extends MovingInteractionBehaviour {

    @Override
    public boolean handlePlayerInteraction(
        class_1657 player,
        class_1268 activeHand,
        class_2338 localPos,
        AbstractContraptionEntity contraptionEntity
    ) {
        if (activeHand == class_1268.field_5810)
            return false;
        class_1937 world = player.method_73183();
        if (world.method_8608())
            return true;

        class_1799 itemInHand = player.method_5998(activeHand);
        MountedStorageManager manager = contraptionEntity.getContraption().getStorage();

        MountedItemStorage storage = manager.getAllItemStorages().get(localPos);
        if (!(storage instanceof DepotMountedStorage depot))
            return false;

        Optional<TransportedItemStack> itemOnDepot = depot.getHeld();
        if (itemOnDepot.isPresent()) {
            class_1799 heldItem = itemOnDepot.get().stack;
            if (class_1799.method_31577(heldItem, itemInHand)) {
                int remainder = heldItem.method_7947();
                int count = itemInHand.method_7947();
                int extract = Math.min(remainder, itemInHand.method_7914() - count);
                if (extract != 0) {
                    itemInHand.method_7939(count + extract);
                    if (extract == remainder) {
                        heldItem = class_1799.field_8037;
                    } else {
                        heldItem.method_7939(remainder - extract);
                    }
                }
            }
            if (!heldItem.method_7960()) {
                player.method_31548().method_7398(heldItem);
                world.method_8396(
                    null,
                    class_2338.method_49638(contraptionEntity.toGlobalVector(class_243.method_24953(localPos), 0)),
                    class_3417.field_15197,
                    class_3419.field_15248,
                    .2f,
                    1f + world.method_8409().method_43057()
                );
                if (itemInHand.method_7960()) {
                    depot.removeHeldItem();
                    depot.method_5431();
                    return true;
                }
            }
        }
        if (itemInHand.method_7960()) {
            return true;
        }

        TransportedItemStack transported = new TransportedItemStack(itemInHand);
        transported.insertedFrom = player.method_5735();
        transported.prevBeltPosition = .25f;
        transported.beltPosition = .25f;
        depot.setHeld(transported);
        depot.method_5431();
        player.method_6122(activeHand, class_1799.field_8037);
        AllSoundEvents.DEPOT_SLIDE.playOnServer(world, class_2338.method_49638(contraptionEntity.toGlobalVector(class_243.method_24953(localPos), 0)));

        return true;
    }

}
