package com.zurrtum.create.content.logistics.factoryBoard;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.codec.CreateCodecs;

import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11580;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4844;
import net.minecraft.class_9334;

public class FactoryPanelBlockItem extends LogisticallyLinkedBlockItem {

    public FactoryPanelBlockItem(class_2248 pBlock, class_1793 pProperties) {
        super(pBlock, pProperties);
    }

    @Override
    public class_1269 method_7712(class_1750 pContext) {
        class_1799 stack = pContext.method_8041();

        if (!isTuned(stack)) {
            AllSoundEvents.DENY.playOnServer(pContext.method_8045(), pContext.method_8037());
            pContext.method_8036().method_7353(class_2561.method_43471("create.factory_panel.tune_before_placing"), true);
            return class_1269.field_5814;
        }

        return super.method_7712(pContext);
    }

    @Override
    protected boolean method_7710(class_2338 pos, class_1937 level, class_1657 player, class_1799 stack, class_2680 state) {
        return super.method_7710(pos, level, player, fixCtrlCopiedStack(stack), state);
    }

    public static class_1799 fixCtrlCopiedStack(class_1799 stack) {
        // Salvage frequency data from one of the panel slots
        if (isTuned(stack) && networkFromStack(stack) == null) {
            class_11580<class_2591<?>> data = stack.method_58694(class_9334.field_49611);
            class_2487 bet;
            class_2591<?> type;
            if (data != null) {
                bet = data.method_72540();
                type = data.method_72530();
            } else {
                bet = new class_2487();
                type = AllBlockEntityTypes.PACKAGER_LINK;
            }
            UUID frequency = UUID.randomUUID();

            for (PanelSlot slot : PanelSlot.values()) {
                Optional<UUID> freq = bet.method_10562(slot.name().toLowerCase(Locale.ROOT)).flatMap(tag -> tag.method_67491("Freq", class_4844.field_25122));
                if (freq.isPresent())
                    frequency = freq.get();
            }

            bet = new class_2487();
            bet.method_67494("Freq", class_4844.field_25122, frequency);
            bet.method_67494("id", CreateCodecs.BLOCK_ENTITY_TYPE_CODEC, ((IBE<?>) ((class_1747) stack.method_7909()).method_7711()).getBlockEntityType());
            stack.method_57379(class_9334.field_49611, class_11580.method_72535(type, bet));
        }

        return stack;
    }

}
