package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import net.minecraft.class_1767;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9283;
import net.minecraft.class_9334;

public record ColorAttribute(class_1767 color) implements ItemAttribute {
    public static final MapCodec<ColorAttribute> CODEC = class_1767.field_41600.xmap(ColorAttribute::new, ColorAttribute::color).fieldOf("value");

    public static final class_9139<ByteBuf, ColorAttribute> PACKET_CODEC = class_1767.field_49259.method_56432(ColorAttribute::new, ColorAttribute::color);

    private static Collection<class_1767> findMatchingDyeColors(class_1799 stack) {
        class_1767 color = AllItemTags.getDyeColor(stack);
        if (color != null)
            return Collections.singletonList(color);

        Set<class_1767> colors = new HashSet<>();
        if (stack.method_57826(class_9334.field_49616)) {
            if (stack.method_7909() instanceof class_1781 || stack.method_31574(class_1802.field_8450)) {
                List<class_9283> explosions = stack.method_58694(class_9334.field_49616).comp_2392();
                for (class_9283 explosion : explosions) {
                    colors.addAll(getFireworkStarColors(explosion));
                }
            }
        }

        Arrays.stream(class_1767.values()).filter(c -> class_7923.field_41178.method_10221(stack.method_7909()).method_12832().startsWith(c.method_7792() + "_"))
            .forEach(colors::add);

        return colors;
    }

    private static Collection<class_1767> getFireworkStarColors(class_9283 explosion) {
        Set<class_1767> colors = new HashSet<>();
        Arrays.stream(explosion.comp_2387().toIntArray()).mapToObj(class_1767::method_7786).forEach(colors::add);
        Arrays.stream(explosion.comp_2388().toIntArray()).mapToObj(class_1767::method_7786).forEach(colors::add);
        return colors;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return findMatchingDyeColors(itemStack).stream().anyMatch(color::equals);
    }

    @Override
    public String getTranslationKey() {
        return "color";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{class_2561.method_43471("color.minecraft." + color.method_7792())};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_COLOR;
    }

    public static class Type implements ItemAttributeType {
        @Override
        public @NotNull ItemAttribute createAttribute() {
            return new ColorAttribute(class_1767.field_7945);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            List<ItemAttribute> list = new ArrayList<>();

            for (class_1767 color : ColorAttribute.findMatchingDyeColors(stack)) {
                list.add(new ColorAttribute(color));
            }

            return list;
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}
