package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class InItemGroupAttribute implements ItemAttribute {
    public static final MapCodec<InItemGroupAttribute> CODEC = class_7923.field_44687.method_39673()
        .xmap(InItemGroupAttribute::new, i -> i.group).fieldOf("value");

    public static final class_9139<ByteBuf, InItemGroupAttribute> PACKET_CODEC = CatnipStreamCodecBuilders.nullable(class_2960.field_48267).method_56432(
        i -> new InItemGroupAttribute(class_7923.field_44687.method_63535(i)),
        i -> i.group == null ? null : class_7923.field_44687.method_10221(i.group)
    );

    @Nullable
    private class_1761 group;

    public InItemGroupAttribute(@Nullable class_1761 group) {
        this.group = group;
    }

    private static boolean tabContainsItem(class_1761 tab, class_1799 stack) {
        return tab.method_45412(stack) || tab.method_45412(new class_1799(stack.method_7909()));
    }

    @Override
    public boolean appliesTo(class_1799 stack, class_1937 world) {
        if (group == null)
            return false;

        if (group.method_47313().isEmpty() && group.method_45414().isEmpty()) {

            try {
                group.method_47306(new class_1761.class_8128(world.method_45162(), false, world.method_30349()));
            } catch (RuntimeException | LinkageError e) {
                Create.LOGGER.error("Attribute Filter: Item Group {} crashed while building contents.", group.method_7737().getString(), e);
                group = null;
                return false;
            }

        }

        return tabContainsItem(group, stack);
    }

    @Override
    public String getTranslationKey() {
        return "in_item_group";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{group == null ? "<none>" : group.method_7737().getString()};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.IN_ITEM_GROUP;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof InItemGroupAttribute that))
            return false;

        return Objects.equals(group, that.group);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(group);
    }

    public static class Type implements ItemAttributeType {
        @Override
        public @NotNull ItemAttribute createAttribute() {
            return new InItemGroupAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            List<ItemAttribute> list = new ArrayList<>();

            for (class_1761 tab : class_7923.field_44687) {
                if (tab.method_47311() && tab.method_47312() == class_1761.class_7916.field_41052 && tabContainsItem(tab, stack)) {
                    list.add(new InItemGroupAttribute(tab));
                }
            }

            return list;
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}
