package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record InTagAttribute(class_6862<class_1792> tag) implements ItemAttribute {
    public static final MapCodec<InTagAttribute> CODEC = class_6862.method_40093(class_7924.field_41197).xmap(InTagAttribute::new, InTagAttribute::tag)
        .fieldOf("value");

    public static final class_9139<ByteBuf, InTagAttribute> PACKET_CODEC = class_6862.method_64143(class_7924.field_41197)
        .method_56432(InTagAttribute::new, InTagAttribute::tag);

    @Override
    public boolean appliesTo(class_1799 stack, class_1937 level) {
        return stack.method_31573(tag);
    }

    @Override
    public String getTranslationKey() {
        return "in_tag";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{"#" + tag.comp_327()};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.IN_TAG;
    }

    public static class Type implements ItemAttributeType {
        @Override
        public @NotNull ItemAttribute createAttribute() {
            return new InTagAttribute(class_3489.field_15539);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            return stack.method_40133().map(InTagAttribute::new).collect(Collectors.toList());
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}
