package com.zurrtum.create.content.logistics.itemHatch;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class ItemHatchBlock extends class_2383 implements IBE<ItemHatchBlockEntity>, IWrenchable, ProperWaterloggedBlock {
    public static final MapCodec<ItemHatchBlock> CODEC = method_54094(ItemHatchBlock::new);

    public static final class_2746 OPEN = class_2746.method_11825("open");

    public ItemHatchBlock(class_2251 pProperties) {
        super(pProperties);
        method_9590(method_9564().method_11657(OPEN, false).method_11657(WATERLOGGED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(OPEN, field_11177, WATERLOGGED));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 state = super.method_9605(pContext);
        if (state == null)
            return state;
        if (pContext.method_8038().method_10166().method_10178())
            return null;

        return withWater(state.method_11657(field_11177, pContext.method_8038().method_10153()).method_11657(OPEN, false), pContext);
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pPos);
        return pState;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (level.method_8608())
            return class_1269.field_5812;
        if (FakePlayerHandler.has(player))
            return class_1269.field_5812;

        class_2586 blockEntity = level.method_8321(pos.method_10093(state.method_11654(field_11177)));
        if (blockEntity == null)
            return class_1269.field_5814;
        class_1263 targetInv = ItemHelper.getInventory(level, blockEntity.method_11016(), null, blockEntity, null);
        if (targetInv == null)
            return class_1269.field_5814;

        ServerFilteringBehaviour filter = BlockEntityBehaviour.get(level, pos, ServerFilteringBehaviour.TYPE);
        if (filter == null)
            return class_1269.field_5814;

        class_1661 inventory = player.method_31548();
        boolean anyInserted = false;
        boolean depositItemInHand = !player.method_5715();

        if (!depositItemInHand && stack.method_31573(AllItemTags.TOOLS_WRENCH))
            return class_1269.field_52423;

        int start, end;
        if (depositItemInHand) {
            start = end = inventory.method_67532();
        } else {
            start = class_1661.method_7368();
            end = class_1661.field_30638 - 1;
        }
        for (int i = start; i <= end; i++) {
            class_1799 item = inventory.method_5438(i);
            if (item.method_7960())
                continue;
            if (!item.method_7909().method_31568() && !PackageItem.isPackage(item))
                continue;
            if (!filter.getFilter().method_7960() && !filter.test(item))
                continue;

            int count = item.method_7947();
            int insert = targetInv.insertExist(item, count);
            if (insert == 0) {
                continue;
            }
            anyInserted = true;
            if (insert == count) {
                inventory.method_5447(i, class_1799.field_8037);
            } else {
                inventory.method_5447(i, item.method_46651(count - insert));
            }
        }

        if (!anyInserted)
            return class_1269.field_5812;

        AllSoundEvents.ITEM_HATCH.playOnServer(level, pos);
        level.method_8501(pos, state.method_11657(OPEN, true));
        level.method_64310(pos, this, 10);

        player.method_7353(
            class_2561.method_43471(depositItemInHand ? "create.item_hatch.deposit_item" : "create.item_hatch.deposit_inventory"),
            true
        );
        return class_1269.field_5812;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.ITEM_HATCH.get(pState.method_11654(field_11177).method_10153());
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        if (pState.method_11654(OPEN))
            pLevel.method_8501(pPos, pState.method_11657(OPEN, false));
    }

    @Override
    public Class<ItemHatchBlockEntity> getBlockEntityClass() {
        return ItemHatchBlockEntity.class;
    }

    @Override
    public class_2591<? extends ItemHatchBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ITEM_HATCH;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }
}