package com.zurrtum.create.content.logistics.redstoneRequester;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour.RequestType;
import com.zurrtum.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.packet.s2c.RedstoneRequesterEffectPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9129;

public class RedstoneRequesterBlockEntity extends StockCheckingBlockEntity implements MenuProvider {

    //TODO
    //    public AbstractComputerBehaviour computerBehaviour;
    public boolean allowPartialRequests;
    public PackageOrderWithCrafts encodedRequest = PackageOrderWithCrafts.empty();
    public String encodedTargetAdress = "";

    public boolean lastRequestSucceeded;

    protected boolean redstonePowered;

    public RedstoneRequesterBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.REDSTONE_REQUESTER, pos, state);
        allowPartialRequests = false;
    }

    //TODO
    //    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
    //        if (Mods.COMPUTERCRAFT.isLoaded()) {
    //            event.registerBlockEntity(
    //                PeripheralCapability.get(),
    //                AllBlockEntityTypes.REDSTONE_REQUESTER.get(),
    //                (be, context) -> be.computerBehaviour.getPeripheralCapability()
    //            );
    //        }
    //    }

    //TODO
    //    @Override
    //    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    //        super.addBehaviours(behaviours);
    //        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    //    }

    //TODO
    //    @Override
    //    public void invalidate() {
    //        super.invalidate();
    //        computerBehaviour.removePeripheral();
    //    }

    protected void onRedstonePowerChanged() {
        boolean hasNeighborSignal = field_11863.method_49803(field_11867);
        if (redstonePowered == hasNeighborSignal)
            return;

        lastRequestSucceeded = false;
        if (hasNeighborSignal)
            triggerRequest();

        redstonePowered = hasNeighborSignal;
        notifyUpdate();
    }

    public void triggerRequest() {
        if (encodedRequest.isEmpty())
            return;

        boolean anySucceeded = false;

        InventorySummary summaryOfOrder = new InventorySummary();
        encodedRequest.stacks().forEach(summaryOfOrder::add);

        InventorySummary summary = getAccurateSummary();
        for (BigItemStack entry : summaryOfOrder.getStacks()) {
            if (summary.getCountOf(entry.stack) >= entry.count) {
                anySucceeded = true;
                continue;
            }
            if (!allowPartialRequests && field_11863 instanceof class_3218 serverLevel) {
                serverLevel.method_8503().method_3760().method_14605(
                    null,
                    field_11867.method_10263(),
                    field_11867.method_10264(),
                    field_11867.method_10260(),
                    32,
                    serverLevel.method_27983(),
                    new RedstoneRequesterEffectPacket(field_11867, false)
                );
                return;
            }
        }

        broadcastPackageRequest(RequestType.REDSTONE, encodedRequest, null, encodedTargetAdress);
        if (field_11863 instanceof class_3218 serverLevel)
            serverLevel.method_8503().method_3760().method_14605(
                null,
                field_11867.method_10263(),
                field_11867.method_10264(),
                field_11867.method_10260(),
                32,
                serverLevel.method_27983(),
                new RedstoneRequesterEffectPacket(field_11867, anySucceeded)
            );
        lastRequestSucceeded = true;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        redstonePowered = view.method_71433("Powered", false);
        lastRequestSucceeded = view.method_71433("Success", false);
        allowPartialRequests = view.method_71433("AllowPartial", false);
        encodedRequest = view.method_71426("EncodedRequest", PackageOrderWithCrafts.CODEC).orElse(PackageOrderWithCrafts.empty());
        encodedTargetAdress = view.method_71428("EncodedAddress", "");
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71472("AllowPartial", allowPartialRequests);
        view.method_71469("EncodedAddress", encodedTargetAdress);
        view.method_71468("EncodedRequest", PackageOrderWithCrafts.CODEC, encodedRequest);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Powered", redstonePowered);
        view.method_71472("Success", lastRequestSucceeded);
        view.method_71472("AllowPartial", allowPartialRequests);
        view.method_71469("EncodedAddress", encodedTargetAdress);
        view.method_71468("EncodedRequest", PackageOrderWithCrafts.CODEC, encodedRequest);
    }

    public class_1269 use(class_1657 player) {
        if (player == null || player.method_18276())
            return class_1269.field_5811;
        if (FakePlayerHandler.has(player))
            return class_1269.field_5811;
        if (field_11863.method_8608())
            return class_1269.field_5812;
        if (!behaviour.mayInteractMessage(player))
            return class_1269.field_5812;

        openHandledScreen((class_3222) player);
        return class_1269.field_5812;
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public RedstoneRequesterMenu createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer, class_9129 extraData) {
        extraData.method_10807(field_11867);
        return new RedstoneRequesterMenu(pContainerId, pPlayerInventory, this);
    }

    public void playEffect(boolean success) {
        class_243 vec3 = class_243.method_24953(field_11867);
        if (success) {
            AllSoundEvents.CONFIRM.playAt(field_11863, field_11867, 0.5f, 1.5f, false);
            AllSoundEvents.STOCK_LINK.playAt(field_11863, field_11867, 1.0f, 1.0f, false);
            field_11863.method_8406(AllParticleTypes.WIFI, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1, 1, 1);
        } else {
            AllSoundEvents.DENY.playAt(field_11863, field_11867, 0.5f, 1, false);
            field_11863.method_8406(class_2398.field_11208, vec3.field_1352, vec3.field_1351 + 1, vec3.field_1350, 0, 0, 0);
        }
    }

}