package com.zurrtum.create.content.logistics.stockTicker;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour.RequestType;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4844;
import net.minecraft.class_9129;

public class StockTickerBlockEntity extends StockCheckingBlockEntity {
    public static final Codec<Map<UUID, List<Integer>>> UUID_MAP_CODEC = Codec.unboundedMap(class_4844.field_41525, Codec.INT.listOf());

    //TODO
    //    public AbstractComputerBehaviour computerBehaviour;

    // Player-interface Feature
    public List<List<BigItemStack>> lastClientsideStockSnapshot;
    protected InventorySummary lastClientsideStockSnapshotAsSummary;
    protected List<BigItemStack> newlyReceivedStockSnapshot;
    public String previouslyUsedAddress;
    public int activeLinks;
    public int ticksSinceLastUpdate;
    public List<class_1799> categories;
    public Map<UUID, List<Integer>> hiddenCategoriesByPlayer;

    // Shop feature
    public StockTickerInventory receivedPayments;

    public StockTickerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.STOCK_TICKER, pos, state);
        previouslyUsedAddress = "";
        receivedPayments = new StockTickerInventory();
        categories = new ArrayList<>();
        hiddenCategoriesByPlayer = new HashMap<>();
    }

    //TODO
    //    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
    //        if (Mods.COMPUTERCRAFT.isLoaded()) {
    //            event.registerBlockEntity(
    //                PeripheralCapability.get(),
    //                AllBlockEntityTypes.STOCK_TICKER.get(),
    //                (be, context) -> be.computerBehaviour.getPeripheralCapability()
    //            );
    //        }
    //    }

    //TODO
    //    @Override
    //    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    //        super.addBehaviours(behaviours);
    //        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    //    }

    //TODO
    //    @Override
    //    public void invalidate() {
    //        super.invalidate();
    //        computerBehaviour.removePeripheral();
    //    }

    public void resetTicksSinceLastUpdate() {
        ticksSinceLastUpdate = 0;
    }

    public class_1263 getReceivedPaymentsHandler() {
        return receivedPayments;
    }

    public List<List<BigItemStack>> getClientStockSnapshot() {
        return lastClientsideStockSnapshot;
    }

    public InventorySummary getLastClientsideStockSnapshotAsSummary() {
        return lastClientsideStockSnapshotAsSummary;
    }

    public int getTicksSinceLastUpdate() {
        return ticksSinceLastUpdate;
    }

    @Override
    public boolean broadcastPackageRequest(RequestType type, PackageOrderWithCrafts order, IdentifiedInventory ignoredHandler, String address) {
        boolean result = super.broadcastPackageRequest(type, order, ignoredHandler, address);
        previouslyUsedAddress = address;
        notifyUpdate();
        return result;
    }

    @Override
    public InventorySummary getRecentSummary() {
        InventorySummary recentSummary = super.getRecentSummary();
        int contributingLinks = recentSummary.contributingLinks;
        if (activeLinks != contributingLinks && !method_11015()) {
            activeLinks = contributingLinks;
            sendData();
        }
        return recentSummary;
    }

    @Override
    public void tick() {
        super.tick();
        if (field_11863.method_8608()) {
            if (ticksSinceLastUpdate < 100)
                ticksSinceLastUpdate += 1;
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71469("PreviousAddress", previouslyUsedAddress);
        receivedPayments.write(view);
        view.method_71468("Categories", CreateCodecs.ITEM_LIST_CODEC, categories);
        view.method_71468("HiddenCategories", UUID_MAP_CODEC, hiddenCategoriesByPlayer);

        if (clientPacket)
            view.method_71465("ActiveLinks", activeLinks);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        previouslyUsedAddress = view.method_71428("PreviousAddress", "");
        receivedPayments.read(view);
        categories.clear();
        view.method_71426("Categories", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> list.forEach(stack -> {
            if (!stack.method_7960() && !(stack.method_7909() instanceof FilterItem)) {
                return;
            }
            categories.add(stack);
        }));
        hiddenCategoriesByPlayer.clear();
        view.method_71426("HiddenCategories", UUID_MAP_CODEC).ifPresent(map -> hiddenCategoriesByPlayer.putAll(map));

        if (clientPacket)
            activeLinks = view.method_71424("ActiveLinks", 0);
    }

    public void receiveStockPacket(List<BigItemStack> stacks, boolean endOfTransmission) {
        if (newlyReceivedStockSnapshot == null)
            newlyReceivedStockSnapshot = new ArrayList<>();
        newlyReceivedStockSnapshot.addAll(stacks);

        if (!endOfTransmission)
            return;

        lastClientsideStockSnapshotAsSummary = new InventorySummary();
        lastClientsideStockSnapshot = new ArrayList<>();

        for (BigItemStack bigStack : newlyReceivedStockSnapshot)
            lastClientsideStockSnapshotAsSummary.add(bigStack);

        for (class_1799 filter : categories) {
            List<BigItemStack> inCategory = new ArrayList<>();
            if (!filter.method_7960()) {
                FilterItemStack filterItemStack = FilterItemStack.of(filter);
                for (Iterator<BigItemStack> iterator = newlyReceivedStockSnapshot.iterator(); iterator.hasNext(); ) {
                    BigItemStack bigStack = iterator.next();
                    if (!filterItemStack.test(field_11863, bigStack.stack))
                        continue;
                    inCategory.add(bigStack);
                    iterator.remove();
                }
            }
            lastClientsideStockSnapshot.add(inCategory);
        }

        List<BigItemStack> unsorted = new ArrayList<>(newlyReceivedStockSnapshot);
        lastClientsideStockSnapshot.add(unsorted);
        newlyReceivedStockSnapshot = null;
    }

    public boolean isKeeperPresent() {
        for (int yOffset : Iterate.zeroAndOne) {
            for (class_2350 side : Iterate.horizontalDirections) {
                class_2338 seatPos = field_11867.method_10087(yOffset).method_10093(side);
                for (SeatEntity seatEntity : field_11863.method_18467(SeatEntity.class, new class_238(seatPos)))
                    if (seatEntity.method_5782())
                        return true;
                if (yOffset == 0) {
                    class_2586 entity = field_11863.method_8321(seatPos);
                    if (entity != null && entity.method_11017() == AllBlockEntityTypes.HEATER) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void destroy() {
        class_1264.method_5451(field_11863, field_11867, receivedPayments);
        int x = field_11867.method_10263();
        int y = field_11867.method_10264();
        int z = field_11867.method_10260();
        for (class_1799 filter : categories) {
            if (!filter.method_7960() && filter.method_7909() instanceof FilterItem) {
                class_1264.method_5449(field_11863, x, y, z, filter);
            }
        }
        super.destroy();
    }

    public void playEffect() {
        AllSoundEvents.STOCK_LINK.playAt(field_11863, field_11867, 1.0f, 1.0f, false);
        class_243 vec3 = class_243.method_24953(field_11867);
        field_11863.method_8406(AllParticleTypes.WIFI, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1, 1, 1);
    }

    public StockKeeperCategoryMenu createCategoryMenu(
        int pContainerId,
        class_1661 pPlayerInventory,
        class_1657 pPlayer,
        class_9129 extraData
    ) {
        extraData.method_10807(field_11867);
        return new StockKeeperCategoryMenu(pContainerId, pPlayerInventory, StockTickerBlockEntity.this);
    }

    public StockKeeperRequestMenu createRequestMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer, class_9129 extraData) {
        boolean showLockOption = behaviour.mayAdministrate(pPlayer) && Create.LOGISTICS.isLockable(behaviour.freqId);
        boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(behaviour.freqId);
        extraData.method_10807(field_11867);
        extraData.method_52964(showLockOption);
        extraData.method_52964(isCurrentlyLocked);
        return new StockKeeperRequestMenu(pContainerId, pPlayerInventory, this);
    }

    public class StockTickerInventory extends ItemStackHandler {
        public StockTickerInventory() {
            super(27);
        }

        @Override
        public void method_5431() {
            notifyUpdate();
        }
    }
}