package com.zurrtum.create.content.logistics.tableCloth;

import com.zurrtum.create.*;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.AutoRequestData;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import com.zurrtum.create.infrastructure.packet.c2s.LogisticalStockRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveBlockEntityPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ShopUpdatePacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import net.minecraft.util.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TableClothBlockEntity extends SmartBlockEntity implements TransformableBlockEntity {

    //TODO
    //    public AbstractComputerBehaviour computerBehaviour;

    public AutoRequestData requestData;
    public List<class_1799> manuallyAddedItems;
    public UUID owner;

    public class_2350 facing;
    public boolean sideOccluded;
    public ServerFilteringBehaviour priceTag;

    private List<class_1799> renderedItemsForShop;

    public TableClothBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TABLE_CLOTH, pos, state);
        manuallyAddedItems = new ArrayList<>();
        requestData = new AutoRequestData();
        owner = null;
        facing = class_2350.field_11035;
    }

    //TODO
    //    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
    //        if (Mods.COMPUTERCRAFT.isLoaded()) {
    //            event.registerBlockEntity(
    //                PeripheralCapability.get(),
    //                AllBlockEntityTypes.TABLE_CLOTH.get(),
    //                (be, context) -> be.computerBehaviour.getPeripheralCapability()
    //            );
    //        }
    //    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(priceTag = new ServerTableClothFilteringBehaviour(this));
        //TODO
        //        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    }

    public List<class_1799> getItemsForRender() {
        if (isShop()) {
            if (renderedItemsForShop == null)
                renderedItemsForShop = requestData.encodedRequest().stacks().stream().map(b -> b.stack).limit(4).toList();
            return renderedItemsForShop;
        }

        return manuallyAddedItems;
    }

    public void invalidateItemsForRender() {
        renderedItemsForShop = null;
    }

    public void notifyShopUpdate() {
        if (field_11863 instanceof class_3218 serverLevel) {
            class_2596<?> packet = new ShopUpdatePacket(field_11867);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(field_11867), false)) {
                player.field_13987.method_14364(packet);
            }
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        class_2338 relativePos = field_11867.method_10093(facing);
        sideOccluded = field_11863.method_8320(relativePos).method_26164(AllBlockTags.TABLE_CLOTHS) || class_2248.method_9501(
            field_11863.method_8320(relativePos.method_10074())
                .method_26201(), facing.method_10153()
        );
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(1);
    }

    public boolean isShop() {
        return !requestData.encodedRequest().isEmpty();
    }

    public class_1269 use(class_1657 player, class_3965 ray) {
        if (isShop())
            return useShop(player);

        class_1799 heldItem = player.method_5998(class_1268.field_5808);

        if (heldItem.method_7960()) {
            if (manuallyAddedItems.isEmpty())
                return class_1269.field_5812;
            player.method_6122(class_1268.field_5808, manuallyAddedItems.remove(manuallyAddedItems.size() - 1));
            field_11863.method_8396(null, field_11867, class_3417.field_14770, class_3419.field_15245, 0.5f, 1f);

            if (manuallyAddedItems.isEmpty()/* && !computerBehaviour.hasAttachedComputer()*/) {
                field_11863.method_8652(field_11867, method_11010().method_11657(TableClothBlock.HAS_BE, false), class_2248.field_31036);
                if (field_11863 instanceof class_3218 serverLevel) {
                    class_2596<?> packet = new RemoveBlockEntityPacket(field_11867);
                    for (class_3222 serverPlayer : serverLevel.method_14178().field_17254.method_17210(new class_1923(field_11867), false)) {
                        serverPlayer.field_13987.method_14364(packet);
                    }
                }
            } else
                notifyUpdate();

            return class_1269.field_5812;
        }

        if (manuallyAddedItems.size() >= 4)
            return class_1269.field_5812;

        field_11863.method_8396(null, field_11867, class_3417.field_14667, class_3419.field_15245, 0.5f, 1f);
        manuallyAddedItems.add(heldItem.method_46651(1));
        facing = player.method_5735().method_10153();
        heldItem.method_7934(1);
        if (heldItem.method_7960())
            player.method_6122(class_1268.field_5808, class_1799.field_8037);
        notifyUpdate();
        return class_1269.field_5812;
    }

    public class_1269 useShop(class_1657 player) {
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        class_1799 prevListItem = class_1799.field_8037;
        boolean addOntoList = false;

        // Remove other lists from inventory
        for (int i = 0; i < 9; i++) {
            class_1799 item = player.method_31548().method_5438(i);
            if (!item.method_31574(AllItems.SHOPPING_LIST))
                continue;
            prevListItem = item;
            addOntoList = true;
            player.method_31548().method_5447(i, class_1799.field_8037);
        }

        // add onto existing list if in hand
        if (itemInHand.method_31574(AllItems.SHOPPING_LIST)) {
            prevListItem = itemInHand;
            addOntoList = true;
        }

        if (!itemInHand.method_7960() && !addOntoList) {
            player.method_7353(class_2561.method_43471("create.stock_keeper.shopping_list_empty_hand"), true);
            AllSoundEvents.DENY.playOnServer(field_11863, field_11867, 0.5f, 1);
            return class_1269.field_5812;
        }

        if (getPaymentItem().method_7960()) {
            player.method_7353(class_2561.method_43471("create.stock_keeper.no_price_set"), true);
            AllSoundEvents.DENY.playOnServer(field_11863, field_11867, 0.5f, 1);
            return class_1269.field_5812;
        }

        UUID tickerID = null;
        class_2338 tickerPos = requestData.targetOffset().method_10081(field_11867);
        if (field_11863.method_8321(tickerPos) instanceof StockTickerBlockEntity stbe && stbe.isKeeperPresent())
            tickerID = stbe.behaviour.freqId;

        int stockLevel = getStockLevelForTrade(ShoppingListItem.getList(prevListItem));

        if (tickerID == null) {
            player.method_7353(class_2561.method_43471("create.stock_keeper.keeper_missing").method_27692(class_124.field_1061), true);
            AllSoundEvents.DENY.playOnServer(field_11863, field_11867, 0.5f, 1);
            return class_1269.field_5812;
        }

        if (stockLevel == 0) {
            player.method_7353(class_2561.method_43471("create.stock_keeper.out_of_stock").method_27692(class_124.field_1061), true);
            AllSoundEvents.DENY.playOnServer(field_11863, field_11867, 0.5f, 1);
            if (!prevListItem.method_7960()) {
                if (player.method_5998(class_1268.field_5808).method_7960())
                    player.method_6122(class_1268.field_5808, prevListItem);
                else
                    player.method_31548().method_7398(prevListItem);
            }

            return class_1269.field_5812;
        }

        ShoppingList list = new ShoppingList(new ArrayList<>(), owner, tickerID);

        if (addOntoList) {
            ShoppingList prevList = ShoppingListItem.getList(prevListItem).duplicate();
            if (owner.equals(prevList.shopOwner()) && tickerID.equals(prevList.shopNetwork()))
                list = prevList;
            else
                addOntoList = false;
        }

        if (list.getPurchases(field_11867) >= stockLevel) {
            for (IntAttached<class_2338> entry : list.purchases())
                if (field_11867.equals(entry.getValue()))
                    entry.setFirst(Math.min(stockLevel, entry.getFirst()));

            player.method_7353(class_2561.method_43471("create.stock_keeper.limited_stock").method_27692(class_124.field_1061), true);
        } else {
            AllSoundEvents.CONFIRM_2.playOnServer(field_11863, field_11867, 0.5f, 1.0f);

            ShoppingList.Mutable mutable = new ShoppingList.Mutable(list);
            mutable.addPurchases(field_11867, 1);
            list = mutable.toImmutable();

            if (!addOntoList)
                player.method_7353(class_2561.method_43471("create.stock_keeper.use_list_to_add_purchases").method_54663(0xeeeeee), true);
            if (!addOntoList)
                field_11863.method_8396(null, field_11867, class_3417.field_17481, class_3419.field_15245, 1, 1.5f);
        }

        class_1799 newListItem = ShoppingListItem.saveList(AllItems.SHOPPING_LIST.method_7854(), list, requestData.encodedTargetAddress());

        if (player.method_5998(class_1268.field_5808).method_7960())
            player.method_6122(class_1268.field_5808, newListItem);
        else
            player.method_31548().method_7398(newListItem);

        return class_1269.field_5812;
    }

    public int getStockLevelForTrade(@Nullable ShoppingList otherPurchases) {
        class_2338 tickerPos = requestData.targetOffset().method_10081(field_11867);
        if (!(field_11863.method_8321(tickerPos) instanceof StockTickerBlockEntity stbe))
            return 0;

        InventorySummary recentSummary;

        if (field_11863.method_8608()) {
            if (stbe.getTicksSinceLastUpdate() > 15) {
                stbe.resetTicksSinceLastUpdate();
                AllClientHandle.INSTANCE.sendPacket(new LogisticalStockRequestPacket(stbe.method_11016()));
            }
            recentSummary = stbe.getLastClientsideStockSnapshotAsSummary();
        } else
            recentSummary = stbe.getRecentSummary();

        if (recentSummary == null)
            return 0;

        InventorySummary modifierSummary = new InventorySummary();
        if (otherPurchases != null)
            modifierSummary = otherPurchases.bakeEntries(field_11863, field_11867).getFirst();

        int smallestQuotient = Integer.MAX_VALUE;
        for (BigItemStack entry : requestData.encodedRequest().stacks())
            if (entry.count > 0)
                smallestQuotient = Math.min(
                    smallestQuotient,
                    (recentSummary.getCountOf(entry.stack) - modifierSummary.getCountOf(entry.stack)) / entry.count
                );

        return smallestQuotient;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("Items", CreateCodecs.ITEM_LIST_CODEC, manuallyAddedItems);
        view.method_71468("Facing", class_2350.field_29502, facing);
        view.method_71468("RequestData", AutoRequestData.CODEC, requestData);
        if (owner != null)
            view.method_71468("OwnerUUID", class_4844.field_25122, owner);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        manuallyAddedItems.clear();
        view.method_71426("Items", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> manuallyAddedItems.addAll(list));
        requestData = view.method_71426("RequestData", AutoRequestData.CODEC).orElseGet(AutoRequestData::new);
        owner = view.method_71426("OwnerUUID", class_4844.field_25122).orElse(null);
        facing = view.method_71426("Facing", class_2350.field_29502).orElse(class_2350.field_11033);
    }

    @Override
    public void destroy() {
        super.destroy();
        manuallyAddedItems.forEach(stack -> class_1264.method_5449(field_11863, field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), stack));
        manuallyAddedItems.clear();
    }

    public class_1799 getPaymentItem() {
        return priceTag.getFilter();
    }

    public int getPaymentAmount() {
        return priceTag.getFilter().method_7960() ? 1 : priceTag.count;
    }

    //TODO
    //    @Override
    //    public void invalidate() {
    //        super.invalidate();
    //        computerBehaviour.removePeripheral();
    //    }

    public void transform(class_2586 blockEntity, StructureTransform transform) {
        facing = transform.mirrorFacing(facing);
        if (transform.rotationAxis == class_2350.class_2351.field_11052)
            facing = transform.rotateFacing(facing);
        notifyUpdate();
    }
}
