package com.zurrtum.create.content.logistics.tunnel;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock.Shape;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.TunnelFlapPacket;

import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BeltTunnelBlockEntity extends SmartBlockEntity {

    public Map<class_2350, LerpedFloat> flaps;
    public Set<class_2350> sides;

    public class_1263 cap = null;
    protected List<Pair<class_2350, Boolean>> flapsToSend;

    public BeltTunnelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        flaps = new EnumMap<>(class_2350.class);
        sides = new HashSet<>();
        flapsToSend = new LinkedList<>();
    }

    public static BeltTunnelBlockEntity andesite(class_2338 pos, class_2680 state) {
        return new BeltTunnelBlockEntity(AllBlockEntityTypes.ANDESITE_TUNNEL, pos, state);
    }

    protected void writeFlapsAndSides(class_11372 view) {
        class_11372.class_11373<class_2350> flapsList = view.method_71467("Flaps", class_2350.field_29502);
        for (class_2350 direction : flaps.keySet())
            flapsList.method_71484(direction);

        class_11372.class_11373<class_2350> sidesList = view.method_71467("Sides", class_2350.field_29502);
        for (class_2350 direction : sides)
            sidesList.method_71484(direction);
    }

    @Override
    public void writeSafe(class_11372 view) {
        writeFlapsAndSides(view);
        super.writeSafe(view);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        writeFlapsAndSides(view);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        Set<class_2350> newFlaps = new HashSet<>(6);
        class_11368.class_11369<class_2350> flapsList = view.method_71437("Flaps", class_2350.field_29502);
        for (class_2350 direction : flapsList)
            newFlaps.add(direction);

        sides.clear();
        class_11368.class_11369<class_2350> sidesList = view.method_71437("Sides", class_2350.field_29502);
        for (class_2350 direction : sidesList)
            sides.add(direction);

        for (class_2350 d : Iterate.directions)
            if (!newFlaps.contains(d))
                flaps.remove(d);
            else if (!flaps.containsKey(d))
                flaps.put(d, createChasingFlap());

        super.read(view, clientPacket);
        if (clientPacket)
            AllClientHandle.INSTANCE.queueUpdate(this);
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(.25f).chase(0, .05f, Chaser.EXP);
    }

    public void updateTunnelConnections() {
        flaps.clear();
        sides.clear();
        class_2680 tunnelState = method_11010();
        for (class_2350 direction : Iterate.horizontalDirections) {
            if (direction.method_10166() != tunnelState.method_11654(class_2741.field_12529)) {
                boolean positive = direction.method_10171() == class_2352.field_11056 ^ direction.method_10166() == class_2351.field_11051;
                Shape shape = tunnelState.method_11654(BeltTunnelBlock.SHAPE);
                if (BeltTunnelBlock.isStraight(tunnelState))
                    continue;
                if (positive && shape == Shape.T_LEFT)
                    continue;
                if (!positive && shape == Shape.T_RIGHT)
                    continue;
            }

            sides.add(direction);

            // Flap might be occluded
            if (field_11863 == null)
                continue;
            class_2680 nextState = field_11863.method_8320(field_11867.method_10093(direction));
            if (nextState.method_26204() instanceof BeltTunnelBlock)
                continue;
            if (nextState.method_26204() instanceof BeltFunnelBlock)
                if (nextState.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && nextState.method_11654(BeltFunnelBlock.HORIZONTAL_FACING) == direction.method_10153())
                    continue;

            flaps.put(direction, createChasingFlap());
        }
        sendData();
    }

    public void flap(class_2350 side, boolean inward) {
        if (field_11863.method_8608()) {
            if (flaps.containsKey(side))
                flaps.get(side).setValue(inward ? -1 : 1);
            return;
        }

        flapsToSend.add(Pair.of(side, inward));
    }

    @Override
    public void initialize() {
        super.initialize();
        updateTunnelConnections();
    }

    @Override
    public void tick() {
        super.tick();
        if (!field_11863.method_8608()) {
            if (!flapsToSend.isEmpty())
                sendFlaps();
            return;
        }
        flaps.forEach((d, value) -> value.tickChaser());
    }

    private void sendFlaps() {
        if (field_11863 instanceof class_3218 serverLevel) {
            TunnelFlapPacket packet = new TunnelFlapPacket(this, flapsToSend);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(field_11867), false)) {
                player.field_13987.method_14364(packet);
            }
        }
        flapsToSend.clear();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }
}
