package com.zurrtum.create.content.logistics.vault;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.ItemPlacementSoundContext;
import net.minecraft.class_11580;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ItemVaultItem extends class_1747 {

    public ItemVaultItem(class_2248 p_i48527_1_, class_1793 p_i48527_2_) {
        super(p_i48527_1_, p_i48527_2_);
    }

    @Override
    public class_1269 method_7712(class_1750 ctx) {
        class_1269 initialResult = super.method_7712(ctx);
        if (!initialResult.method_23665())
            return initialResult;
        tryMultiPlace(ctx);
        return initialResult;
    }

    @Override
    protected boolean method_7710(class_2338 blockPos, class_1937 level, class_1657 player, class_1799 itemStack, class_2680 blockState) {
        MinecraftServer minecraftserver = level.method_8503();
        if (minecraftserver == null)
            return false;
        class_11580<class_2591<?>> data = itemStack.method_58694(class_9334.field_49611);
        if (data != null) {
            class_2487 nbt = data.method_72540();
            nbt.method_10551("Length");
            nbt.method_10551("Size");
            nbt.method_10551("Controller");
            nbt.method_10551("LastKnownPos");
            itemStack.method_57379(class_9334.field_49611, class_11580.method_72535(((IBE<?>) method_7711()).getBlockEntityType(), nbt));
        }
        return super.method_7710(blockPos, level, player, itemStack, blockState);
    }

    private void tryMultiPlace(class_1750 ctx) {
        class_1657 player = ctx.method_8036();
        if (player == null)
            return;
        if (player.method_5715())
            return;
        class_2350 face = ctx.method_8038();
        class_1799 stack = ctx.method_8041();
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2338 placedOnPos = pos.method_10093(face.method_10153());
        class_2680 placedOnState = world.method_8320(placedOnPos);

        if (!ItemVaultBlock.isVault(placedOnState))
            return;
        if (SymmetryWandItem.presentInHotbar(player))
            return;
        ItemVaultBlockEntity tankAt = ConnectivityHandler.partAt(AllBlockEntityTypes.ITEM_VAULT, world, placedOnPos);
        if (tankAt == null)
            return;
        ItemVaultBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null)
            return;

        int width = controllerBE.radius;
        if (width == 1)
            return;

        int tanksToPlace = 0;
        class_2351 vaultBlockAxis = ItemVaultBlock.getVaultBlockAxis(placedOnState);
        if (vaultBlockAxis == null)
            return;
        if (face.method_10166() != vaultBlockAxis)
            return;

        class_2350 vaultFacing = class_2350.method_10169(vaultBlockAxis, class_2350.class_2352.field_11056);
        class_2338 startPos = face == vaultFacing.method_10153() ? controllerBE.method_11016()
            .method_10093(vaultFacing.method_10153()) : controllerBE.method_11016().method_10079(vaultFacing, controllerBE.length);

        if (VecHelper.getCoordinate(startPos, vaultBlockAxis) != VecHelper.getCoordinate(pos, vaultBlockAxis))
            return;

        for (int xOffset = 0; xOffset < width; xOffset++) {
            for (int zOffset = 0; zOffset < width; zOffset++) {
                class_2338 offsetPos = vaultBlockAxis == class_2351.field_11048 ? startPos.method_10069(0, xOffset, zOffset) : startPos.method_10069(xOffset, zOffset, 0);
                class_2680 blockState = world.method_8320(offsetPos);
                if (ItemVaultBlock.isVault(blockState))
                    continue;
                if (!blockState.method_45474())
                    return;
                tanksToPlace++;
            }
        }

        if (!player.method_68878() && stack.method_7947() < tanksToPlace)
            return;

        ItemPlacementSoundContext context = new ItemPlacementSoundContext(ctx, 0.1f, 1.5f, null);
        for (int xOffset = 0; xOffset < width; xOffset++) {
            for (int zOffset = 0; zOffset < width; zOffset++) {
                class_2338 offsetPos = vaultBlockAxis == class_2351.field_11048 ? startPos.method_10069(0, xOffset, zOffset) : startPos.method_10069(xOffset, zOffset, 0);
                class_2680 blockState = world.method_8320(offsetPos);
                if (ItemVaultBlock.isVault(blockState))
                    continue;
                super.method_7712(context.offset(offsetPos, face));
            }
        }
    }

}
