package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.fluids.transfer.GenericItemFilling;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;

import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2754;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_9334;

public class BasinBlock extends class_2248 implements IBE<BasinBlockEntity>, IWrenchable, ItemInventoryProvider<BasinBlockEntity>, FluidInventoryProvider<BasinBlockEntity> {

    public static final class_2754<class_2350> FACING = class_2754.method_11848("facing", class_2350.class, side -> side != class_2350.field_11036);

    public BasinBlock(class_2251 p_i48440_1_) {
        super(p_i48440_1_);
        method_9590(method_9564().method_11657(FACING, class_2350.field_11033));
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, BasinBlockEntity blockEntity, class_2350 context) {
        return blockEntity.itemCapability;
    }

    @Override
    public FluidInventory getFluidInventory(class_1936 world, class_2338 pos, class_2680 state, BasinBlockEntity blockEntity, class_2350 context) {
        return blockEntity.fluidCapability;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> p_206840_1_) {
        super.method_9515(p_206840_1_.method_11667(FACING));
    }

    public static boolean isBasin(class_4538 world, class_2338 pos) {
        return world.method_8321(pos) instanceof BasinBlockEntity;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return !(world.method_8321(pos.method_10084()) instanceof BasinOperatingBlockEntity);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (!context.method_8045().method_8608())
            withBlockEntityDo(context.method_8045(), context.method_8037(), bte -> bte.onWrenched(context.method_8038()));
        return class_1269.field_5812;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        return onBlockEntityUseItemOn(
            level, pos, be -> {
                if (!stack.method_7960()) {
                    if (FluidHelper.tryEmptyItemIntoBE(level, player, hand, stack, be))
                        return class_1269.field_5812;
                    if (FluidHelper.tryFillItemFromBE(level, player, hand, stack, be))
                        return class_1269.field_5812;

                    if (GenericItemEmptying.canItemBeEmptied(level, stack) || GenericItemFilling.canItemBeFilled(level, stack))
                        return class_1269.field_5812;
                    if (stack.method_7909().equals(class_1802.field_8535)) {
                        FluidInventory fluidHandler = be.fluidCapability;
                        if (fluidHandler != null) {
                            boolean drained = false;
                            for (int i = 0, size = fluidHandler.size(); i < size; i++) {
                                if (fluidHandler.getStack(i).isEmpty()) {
                                    continue;
                                }
                                fluidHandler.setStack(i, FluidStack.EMPTY);
                                drained = true;
                            }
                            if (drained) {
                                fluidHandler.markDirty();
                                return class_1269.field_5812;
                            }
                        }
                    }
                    return class_1269.field_52423;
                }

                class_1263 inv = be.itemCapability;
                if (inv == null)
                    inv = new ItemStackHandler(1);
                boolean success = false;
                for (int slot = 0, size = inv.method_5439(); slot < size; slot++) {
                    class_1799 stackInSlot = inv.method_5438(slot);
                    if (stackInSlot.method_7960())
                        continue;
                    player.method_31548().method_7398(stackInSlot);
                    inv.method_5447(slot, class_1799.field_8037);
                    success = true;
                }
                if (success)
                    level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, .2f, 1f + level.method_8409().method_43057());
                be.onEmptied();
                return class_1269.field_5812;
            }
        );
    }

    @Override
    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        if (!worldIn.method_8320(entityIn.method_24515()).method_27852(this))
            return;
        if (!(entityIn instanceof class_1542 itemEntity))
            return;
        if (!entityIn.method_5805())
            return;
        withBlockEntityDo(
            worldIn, entityIn.method_24515(), be -> {
                class_1799 stack = itemEntity.method_6983();
                int count = stack.method_7947();
                int insert = be.itemCapability.insert(stack);
                if (insert == count) {
                    itemEntity.method_31472();
                } else if (insert != 0) {
                    stack.method_7934(insert);
                    itemEntity.method_6979(stack);
                }
            }
        );
    }

    @Override
    public class_265 method_9584(class_2680 p_199600_1_, class_1922 p_199600_2_, class_2338 p_199600_3_) {
        return AllShapes.BASIN_RAYTRACE_SHAPE;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.BASIN_BLOCK_SHAPE;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 reader, class_2338 pos, class_3726 ctx) {
        if (ctx instanceof class_3727 entityShapeContext && entityShapeContext.method_32480() instanceof class_1542)
            return AllShapes.BASIN_COLLISION_SHAPE;
        return method_9530(state, reader, pos, ctx);
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 blockState, class_1937 worldIn, class_2338 pos, class_2350 direction) {
        Optional<BasinBlockEntity> getter = getBlockEntityOptional(worldIn, pos);
        if (getter.isEmpty()) {
            return 0;
        }
        BasinInventory inv = getter.get().itemCapability;
        int i = 0;
        float f = 0.0F;
        for (int j = 0; j < 9; ++j) {
            int slotLimit = inv.method_5444();
            class_1799 itemstack = inv.method_5438(j);
            if (!itemstack.method_7960()) {
                f += (float) itemstack.method_7947() / (float) Math.min(slotLimit, itemstack.method_58695(class_9334.field_50071, 64));
                ++i;
            }
        }
        return class_3532.method_15375(f / 9 * 14.0F) + (i > 0 ? 1 : 0);
    }

    @Override
    public Class<BasinBlockEntity> getBlockEntityClass() {
        return BasinBlockEntity.class;
    }

    @Override
    public class_2591<? extends BasinBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.BASIN;
    }

    public static boolean canOutputTo(class_1922 world, class_2338 basinPos, class_2350 direction) {
        class_2338 neighbour = basinPos.method_10093(direction);
        class_2338 output = neighbour.method_10074();
        class_2680 blockState = world.method_8320(neighbour);

        if (FunnelBlock.isFunnel(blockState)) {
            if (FunnelBlock.getFunnelFacing(blockState) == direction)
                return false;
        } else if (!blockState.method_26220(world, neighbour).method_1110()) {
            return false;
        } else {
            class_2586 blockEntity = world.method_8321(output);
            if (blockEntity instanceof BeltBlockEntity belt) {
                return belt.getSpeed() == 0 || belt.getMovementFacing() != direction.method_10153();
            }
        }

        DirectBeltInputBehaviour directBeltInputBehaviour = BlockEntityBehaviour.get(world, output, DirectBeltInputBehaviour.TYPE);
        if (directBeltInputBehaviour != null)
            return directBeltInputBehaviour.canInsertFromSide(direction);
        return false;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

}
