package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.simple.DeferralBehaviour;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import com.zurrtum.create.foundation.recipe.trie.AbstractVariant;
import com.zurrtum.create.foundation.recipe.trie.RecipeTrie;
import com.zurrtum.create.foundation.recipe.trie.RecipeTrieFinder;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_8786;

public abstract class BasinOperatingBlockEntity extends KineticBlockEntity {

    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected class_1860<?> currentRecipe;
    private final BasinRecipeFinder finder;

    public BasinOperatingBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        finder = new BasinRecipeFinder();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        basinChecker = new DeferralBehaviour(this, this::updateBasin);
        behaviours.add(basinChecker);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        basinRemoved = false;
        basinChecker.scheduleUpdate();
    }

    @Override
    public void tick() {
        if (basinRemoved) {
            basinRemoved = false;
            onBasinRemoved();
            sendData();
            return;
        }

        super.tick();
    }

    protected boolean updateBasin() {
        if (!isSpeedRequirementFulfilled())
            return true;
        if (getSpeed() == 0)
            return true;
        if (isRunning())
            return true;
        if (field_11863 == null || field_11863.method_8608())
            return true;
        Optional<BasinBlockEntity> basin = getBasin();
        if (basin.filter(BasinBlockEntity::canContinueProcessing).isEmpty())
            return true;

        class_1860<?> recipe = getMatchingRecipes();
        if (recipe == null)
            return true;
        currentRecipe = recipe;
        startProcessingBasin();
        sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingBasin() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    protected boolean matchBasinRecipe(class_1860<?> recipe) {
        if (recipe == null)
            return false;
        return getBasin().map(blockEntity -> switch (recipe) {
            case BasinRecipe basinRecipe -> basinRecipe.method_8115(new BasinInput(blockEntity), field_11863);
            case class_1869 shapedRecipe -> BasinRecipe.matchCraftingRecipe(new BasinInput(blockEntity), shapedRecipe, field_11863);
            case class_1867 shapelessRecipe -> BasinRecipe.matchCraftingRecipe(new BasinInput(blockEntity), shapelessRecipe, field_11863);
            default -> false;
        }).orElse(false);

    }

    protected void applyBasinRecipe() {
        if (currentRecipe == null)
            return;

        Optional<BasinBlockEntity> optionalBasin = getBasin();
        if (optionalBasin.isEmpty())
            return;
        BasinBlockEntity basin = optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        switch (currentRecipe) {
            case BasinRecipe basinRecipe -> {
                if (!basinRecipe.apply(new BasinInput(basin)))
                    return;
            }
            case class_1869 shapedRecipe -> {
                if (!BasinRecipe.applyCraftingRecipe(new BasinInput(basin), shapedRecipe, field_11863))
                    return;
            }
            case class_1867 shapelessRecipe -> {
                if (!BasinRecipe.applyCraftingRecipe(new BasinInput(basin), shapelessRecipe, field_11863))
                    return;
            }
            default -> {
                return;
            }
        }
        getProcessedRecipeTrigger().ifPresent(this::award);
        basin.inputTank.sendDataImmediately();

        // Continue mixing
        if (wasEmpty && matchBasinRecipe(currentRecipe)) {
            continueWithPreviousRecipe();
            sendData();
        }

        basin.notifyChangeOfContents();
    }

    protected class_1860<?> getMatchingRecipes() {
        Optional<BasinBlockEntity> $basin = getBasin();
        BasinBlockEntity basin;
        if ($basin.isEmpty() || (basin = $basin.get()).isEmpty())
            return null;
        if (basin.itemCapability == null && basin.fluidCapability == null) {
            return null;
        }
        try {
            RecipeTrie<class_1860<?>> trie = RecipeTrieFinder.get(getRecipeCacheKey(), (class_3218) field_11863, this::matchStaticFilters);
            Set<AbstractVariant> availableVariants = RecipeTrie.getVariants(basin.itemCapability, basin.fluidCapability);
            return finder.match(basin, trie.lookup(availableVariants));
        } catch (Exception e) {
            Create.LOGGER.error("Failed to get recipe trie, falling back to slow logic", e);
            List<class_8786<? extends class_1860<?>>> recipes = RecipeFinder.get(getRecipeCacheKey(), (class_3218) field_11863, this::matchStaticFilters);
            if (recipes.isEmpty()) {
                return null;
            }
            return finder.matchEntry(basin, recipes);
        }
    }

    protected abstract void onBasinRemoved();

    protected Optional<BasinBlockEntity> getBasin() {
        if (field_11863 == null)
            return Optional.empty();
        class_2586 basinBE = field_11863.method_8321(field_11867.method_10087(2));
        if (!(basinBE instanceof BasinBlockEntity))
            return Optional.empty();
        return Optional.of((BasinBlockEntity) basinBE);
    }

    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.empty();
    }

    protected abstract boolean matchStaticFilters(class_8786<? extends class_1860<?>> recipe);

    protected abstract Object getRecipeCacheKey();

    private class BasinRecipeFinder {
        private BasinInput basinInput;
        private Consumer<class_1860<?>> matchingStrategy;
        private class_1860<?> matchedRecipe;
        private int ingredientCount;

        public class_1860<?> match(BasinBlockEntity basin, List<class_1860<?>> recipes) {
            matchedRecipe = null;
            matchingStrategy = this::firstMatchStrategy;
            basinInput = new BasinInput(basin);
            for (class_1860<?> recipe : recipes) {
                matchingStrategy.accept(recipe);
            }
            return matchedRecipe;
        }

        public class_1860<?> matchEntry(BasinBlockEntity basin, List<class_8786<? extends class_1860<?>>> recipes) {
            matchedRecipe = null;
            matchingStrategy = this::firstMatchStrategy;
            basinInput = new BasinInput(basin);
            for (class_8786<? extends class_1860<?>> recipe : recipes) {
                matchingStrategy.accept(recipe.comp_1933());
            }
            return matchedRecipe;
        }

        private void updateMatchedRecipe(class_1860<?> recipe, int size) {
            matchedRecipe = recipe;
            ingredientCount = size;
        }

        private void firstMatchStrategy(class_1860<?> candidateRecipe) {
            switch (candidateRecipe) {
                case BasinRecipe recipe -> {
                    if (recipe.method_8115(basinInput, field_11863)) {
                        updateMatchedRecipe(recipe, recipe.getIngredientSize());
                        matchingStrategy = this::selectBetterMatch;
                    }
                }
                case class_1869 recipe -> {
                    if (BasinRecipe.matchCraftingRecipe(basinInput, recipe, field_11863)) {
                        updateMatchedRecipe(recipe, (int) recipe.method_61693().stream().filter(Optional::isPresent).count());
                        matchingStrategy = this::selectBetterMatch;
                    }
                }
                case class_1867 recipe -> {
                    if (BasinRecipe.matchCraftingRecipe(basinInput, recipe, field_11863)) {
                        updateMatchedRecipe(recipe, recipe.field_9047.size());
                        matchingStrategy = this::selectBetterMatch;
                    }
                }
                default -> {
                }
            }
        }

        private void selectBetterMatch(class_1860<?> candidateRecipe) {
            switch (candidateRecipe) {
                case BasinRecipe recipe -> {
                    int count = recipe.getIngredientSize();
                    if (count > ingredientCount && recipe.method_8115(basinInput, field_11863)) {
                        updateMatchedRecipe(recipe, count);
                    }
                }
                case class_1869 recipe -> {
                    int count = recipe.method_61693().size();
                    if (count > ingredientCount && BasinRecipe.matchCraftingRecipe(basinInput, recipe, field_11863)) {
                        updateMatchedRecipe(recipe, count);
                    }
                }
                case class_1867 recipe -> {
                    int count = recipe.field_9047.size();
                    if (count > ingredientCount && BasinRecipe.matchCraftingRecipe(basinInput, recipe, field_11863)) {
                        updateMatchedRecipe(recipe, count);
                    }
                }
                default -> {
                }
            }
        }
    }
}