package com.zurrtum.create.content.processing.burner;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.block.IBE;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2754;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class BlazeBurnerBlock extends class_2383 implements IBE<BlazeBurnerBlockEntity>, IWrenchable, SpecialBlockItemRequirement {
    public static final MapCodec<BlazeBurnerBlock> field_46280 = method_54094(BlazeBurnerBlock::new);
    public static final class_2754<HeatLevel> HEAT_LEVEL = class_2754.method_11850("blaze", HeatLevel.class);

    public BlazeBurnerBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(HEAT_LEVEL, HeatLevel.NONE));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(HEAT_LEVEL, field_11177);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 p_220082_4_, boolean p_220082_5_) {
        if (world.method_8608())
            return;
        class_2586 blockEntity = world.method_8321(pos.method_10084());
        if (!(blockEntity instanceof BasinBlockEntity basin))
            return;
        basin.notifyChangeOfContents();
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(HEAT_LEVEL) == HeatLevel.NONE)
            return null;
        return IBE.super.method_10123(pos, state);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        HeatLevel heat = state.method_11654(HEAT_LEVEL);

        if (stack.method_31574(AllItems.GOGGLES) && heat != HeatLevel.NONE)
            return onBlockEntityUseItemOn(
                level, pos, bbte -> {
                    if (bbte.goggles)
                        return class_1269.field_52423;
                    bbte.goggles = true;
                    bbte.notifyUpdate();
                    return class_1269.field_5812;
                }
            );

        BlazeBurnerBlockEntity be = getBlockEntity(level, pos);
        if (be != null && be.stockKeeper) {
            StockTickerBlockEntity stockTicker = BlazeBurnerBlockEntity.getStockTicker(level, pos);
            if (stockTicker != null)
                StockTickerInteractionHandler.interactWithLogisticsManagerAt(player, level, stockTicker.method_11016());
            return class_1269.field_5812;
        }

        if (stack.method_7960() && heat != HeatLevel.NONE)
            return onBlockEntityUseItemOn(
                level, pos, bbte -> {
                    if (!bbte.goggles)
                        return class_1269.field_52423;
                    bbte.goggles = false;
                    bbte.notifyUpdate();
                    return class_1269.field_5812;
                }
            );

        if (heat == HeatLevel.NONE) {
            if (stack.method_7909() instanceof class_1786) {
                level.method_8396(player, pos, class_3417.field_15145, class_3419.field_15245, 1.0F, level.field_9229.method_43057() * 0.4F + 0.8F);
                if (level.method_8608())
                    return class_1269.field_5812;
                stack.method_7970(1, player, hand.method_73186());
                level.method_8501(pos, AllBlocks.LIT_BLAZE_BURNER.method_9564());
                return class_1269.field_5812;
            }
            return class_1269.field_52423;
        }

        boolean doNotConsume = player.method_68878();
        boolean forceOverflow = !FakePlayerHandler.has(player);

        class_1269 res = tryInsert(state, level, pos, stack, doNotConsume, forceOverflow, false);
        if (res instanceof class_1269.class_9860 success) {
            class_1799 leftover = success.method_61396();
            if (!level.method_8608() && !doNotConsume && leftover != null && !leftover.method_7960()) {
                if (stack.method_7960()) {
                    player.method_6122(hand, leftover);
                } else if (!player.method_31548().method_7394(leftover)) {
                    player.method_7328(leftover, false);
                }
            }
        }

        if (res.method_23665())
            return res;
        return class_1269.field_52423;
    }

    public static class_1269 tryInsert(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_1799 stack,
        boolean doNotConsume,
        boolean forceOverflow,
        boolean simulate
    ) {
        if (!state.method_31709())
            return class_1269.field_5814;

        class_2586 be = world.method_8321(pos);
        if (!(be instanceof BlazeBurnerBlockEntity burnerBE))
            return class_1269.field_5814;

        if (burnerBE.isCreativeFuel(stack)) {
            if (!simulate)
                burnerBE.applyCreativeFuel();
            return class_1269.field_5812.method_61393(class_1799.field_8037);
        }
        if (!burnerBE.tryUpdateFuel(stack, forceOverflow, simulate))
            return class_1269.field_5814;

        if (!doNotConsume) {
            class_1799 container = stack.method_7909().method_7858();
            if (!world.method_8608()) {
                stack.method_7934(1);
            }
            return class_1269.field_5812.method_61393(container);
        }
        return class_1269.field_5812.method_61393(class_1799.field_8037);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_1799 stack = context.method_8041();
        class_1792 item = stack.method_7909();
        class_2680 defaultState = method_9564();
        if (!(item instanceof BlazeBurnerBlockItem))
            return defaultState;
        HeatLevel initialHeat = ((BlazeBurnerBlockItem) item).hasCapturedBlaze() ? HeatLevel.SMOULDERING : HeatLevel.NONE;
        return defaultState.method_11657(HEAT_LEVEL, initialHeat).method_11657(field_11177, context.method_8042().method_10153());
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 reader, class_2338 pos, class_3726 context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    @Override
    public class_265 method_9549(class_2680 p_220071_1_, class_1922 p_220071_2_, class_2338 p_220071_3_, class_3726 p_220071_4_) {
        if (p_220071_4_ == class_3726.method_16194())
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        return method_9530(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    @Override
    public boolean method_9498(class_2680 p_149740_1_) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 p_180641_2_, class_2338 p_180641_3_, class_2350 direction) {
        return Math.max(0, state.method_11654(HEAT_LEVEL).ordinal() - 1);
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(10) != 0)
            return;
        if (!state.method_11654(HEAT_LEVEL).isAtLeast(HeatLevel.SMOULDERING))
            return;
        world.method_8486(
            pos.method_10263() + 0.5F,
            pos.method_10264() + 0.5F,
            pos.method_10260() + 0.5F,
            class_3417.field_17483,
            class_3419.field_15245,
            0.5F + random.method_43057(),
            random.method_43057() * 0.7F + 0.6F,
            false
        );
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }

    public static HeatLevel getHeatLevelOf(class_2680 blockState) {
        return blockState.method_28498(BlazeBurnerBlock.HEAT_LEVEL) ? blockState.method_11654(BlazeBurnerBlock.HEAT_LEVEL) : HeatLevel.NONE;
    }

    public static int getLight(class_2680 state) {
        HeatLevel level = state.method_11654(HEAT_LEVEL);
        return switch (level) {
            case NONE -> 0;
            case SMOULDERING -> 8;
            default -> 15;
        };
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return getLitOrUnlitStack(state);
    }

    @Override
    public Class<BlazeBurnerBlockEntity> getBlockEntityClass() {
        return BlazeBurnerBlockEntity.class;
    }

    @Override
    public class_2591<? extends BlazeBurnerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.HEATER;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, @Nullable class_2586 blockEntity) {
        return new ItemRequirement(ItemUseType.CONSUME, getLitOrUnlitStack(state));
    }

    private static class_1799 getLitOrUnlitStack(class_2680 state) {
        boolean isLit = state.method_11654(HEAT_LEVEL) != HeatLevel.NONE;
        return (isLit ? AllItems.BLAZE_BURNER : AllItems.EMPTY_BLAZE_BURNER).method_7854();
    }

    public enum HeatLevel implements class_3542 {
        NONE,
        SMOULDERING,
        FADING,
        KINDLED,
        SEETHING;

        public static final Codec<HeatLevel> CODEC = class_3542.method_28140(HeatLevel::values);

        public static HeatLevel byIndex(int index) {
            return values()[index];
        }

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }

        public boolean isAtLeast(HeatLevel heatLevel) {
            return this.ordinal() >= heatLevel.ordinal();
        }

        public HeatLevel nextActiveLevel() {
            return byIndex(ordinal() % (values().length - 1) + 1);
        }
    }

}
