package com.zurrtum.create.content.redstone.contact;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn.ColumnCoords;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8235;
import org.jetbrains.annotations.Nullable;

public class RedstoneContactBlock extends WrenchableDirectionalBlock implements RedStoneConnectBlock, WeakPowerControlBlock {

    public static final class_2746 POWERED = class_2741.field_12484;

    public RedstoneContactBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(POWERED, false).method_11657(field_10927, class_2350.field_11036));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(POWERED);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = method_9564().method_11657(field_10927, context.method_7715().method_10153());
        class_2350 placeDirection = context.method_8038().method_10153();

        if ((context.method_8036() != null && context.method_8036().method_5715()) || hasValidContact(
            context.method_8045(),
            context.method_8037(),
            placeDirection
        ))
            state = state.method_11657(field_10927, placeDirection);
        if (hasValidContact(context.method_8045(), context.method_8037(), state.method_11654(field_10927)))
            state = state.method_11657(POWERED, true);

        return state;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1269 onWrenched = super.onWrenched(state, context);
        if (onWrenched != class_1269.field_5812)
            return onWrenched;

        class_1937 level = context.method_8045();
        if (level.method_8608())
            return onWrenched;

        class_2338 pos = context.method_8037();
        state = level.method_8320(pos);
        class_2350 facing = state.method_11654(RedstoneContactBlock.field_10927);
        if (facing.method_10166() == class_2351.field_11052)
            return onWrenched;
        if (ElevatorColumn.get(level, new ColumnCoords(pos.method_10263(), pos.method_10260(), facing)) == null)
            return onWrenched;

        level.method_8501(pos, BlockHelper.copyProperties(state, AllBlocks.ELEVATOR_CONTACT.method_9564()));

        return onWrenched;
    }

    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_27852(this) && oldState == state.method_28493(POWERED)) {
            world.method_8452(pos, this, null);
        }
    }

    @Override
    public class_2680 method_9559(
        class_2680 stateIn,
        class_4538 world,
        class_10225 tickView,
        class_2338 currentPos,
        class_2350 facing,
        class_2338 facingPos,
        class_2680 facingState,
        class_5819 random
    ) {
        if (facing != stateIn.method_11654(field_10927))
            return stateIn;
        boolean hasValidContact = hasValidContact(world, currentPos, facing);
        if (stateIn.method_11654(POWERED) != hasValidContact)
            return stateIn.method_11657(POWERED, hasValidContact);
        return stateIn;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        boolean hasValidContact = hasValidContact(worldIn, pos, state.method_11654(field_10927));
        if (state.method_11654(POWERED) != hasValidContact)
            worldIn.method_8501(pos, state.method_11657(POWERED, hasValidContact));
    }

    public static boolean hasValidContact(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2680 blockState = world.method_8320(pos.method_10093(direction));
        return (blockState.method_27852(AllBlocks.REDSTONE_CONTACT) || blockState.method_27852(AllBlocks.ELEVATOR_CONTACT)) && blockState.method_11654(field_10927) == direction.method_10153();
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return state.method_11654(POWERED);
    }

    @Override
    public boolean canConnectRedstone(class_2680 state, @Nullable class_2350 side) {
        return side != null && state.method_11654(field_10927) != side.method_10153();
    }

    @Override
    public int method_9524(class_2680 state, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        return state.method_11654(POWERED) && side != state.method_11654(field_10927).method_10153() ? 15 : 0;
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }
}
