package com.zurrtum.create.content.redstone.diodes;

import com.mojang.serialization.Codec;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerBrassDiodeScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

import static com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock.POWERING;

public abstract class BrassDiodeBlockEntity extends SmartBlockEntity implements ClipboardCloneable {

    public int state;
    ServerScrollValueBehaviour maxState;

    public BrassDiodeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        maxState = new ServerBrassDiodeScrollValueBehaviour(this).between(2, 60 * 20 * 60);
        maxState.withCallback(this::onMaxDelayChanged);
        maxState.setValue(defaultValue());
        behaviours.add(maxState);
    }

    protected int defaultValue() {
        return 2;
    }

    public float getProgress() {
        int max = Math.max(2, maxState.getValue());
        return class_3532.method_15340(state, 0, max) / (float) max;
    }

    public boolean isIdle() {
        return state == 0;
    }

    @Override
    public void tick() {
        super.tick();
        boolean powered = method_11010().method_11654(class_2312.field_10911);
        boolean powering = method_11010().method_11654(POWERING);
        boolean atMax = state >= maxState.getValue();
        boolean atMin = state <= 0;
        updateState(powered, powering, atMax, atMin);
    }

    protected abstract void updateState(boolean powered, boolean powering, boolean atMax, boolean atMin);

    private void onMaxDelayChanged(int newMax) {
        state = class_3532.method_15340(state, 0, newMax);
        sendData();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        state = view.method_71424("State", 0);
        super.read(view, clientPacket);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("State", state);
        super.write(view, clientPacket);
    }

    @Override
    public String getClipboardKey() {
        return "Block";
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        Optional<Boolean> inverted = view.method_71426("Inverted", Codec.BOOL);
        if (inverted.isEmpty())
            return false;
        if (simulate)
            return true;
        class_2680 blockState = method_11010();
        if (blockState.method_11654(BrassDiodeBlock.INVERTED) != inverted.get())
            field_11863.method_8501(field_11867, blockState.method_28493(BrassDiodeBlock.INVERTED));
        return true;
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        view.method_71468("Inverted", Codec.BOOL, method_11010().method_61767(BrassDiodeBlock.INVERTED, false));
        return true;
    }

}