package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class ItemCountDisplaySource extends NumericSingleLineDisplaySource {
    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        class_2586 sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof SmartObserverBlockEntity cobe))
            return ZERO.method_27661();

        InvManipulationBehaviour invManipulationBehaviour = cobe.getBehaviour(InvManipulationBehaviour.TYPE);
        ServerFilteringBehaviour filteringBehaviour = cobe.getBehaviour(ServerFilteringBehaviour.TYPE);
        class_1263 handler = invManipulationBehaviour.getInventory();

        if (handler == null)
            return ZERO.method_27661();

        int collected = 0;
        for (int i = 0, size = handler.method_5439(); i < size; i++) {
            class_1799 stack = handler.method_5438(i);
            if (stack.method_7960())
                continue;
            if (filteringBehaviour.test(stack))
                collected += stack.method_7947();
        }

        return class_2561.method_43470(String.valueOf(collected));
    }

    @Override
    protected String getTranslationKey() {
        return "count_items";
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}