package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class ItemThroughputDisplaySource extends AccumulatedItemCountDisplaySource {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

    static final int POOL_SIZE = 10;

    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        class_2487 conf = context.sourceConfig();
        if (conf.method_10545("Inactive"))
            return ZERO.method_27661();

        double interval = 20 * Math.pow(60, conf.method_68083("Interval", 0));
        double rate = conf.method_66563("Rate", 0) * interval;

        if (rate > 0) {
            long previousTime = conf.method_68080("LastReceived", 0);
            long gameTime = context.blockEntity().method_10997().method_75260();
            int diff = (int) (gameTime - previousTime);
            if (diff > 0) {
                // Too long since last item
                int lastAmount = conf.method_68083("LastReceivedAmount", 0);
                double timeBetweenStacks = lastAmount / rate;
                if (diff > timeBetweenStacks * 2)
                    conf.method_10556("Inactive", true);
            }
        }

        if (class_3532.method_20390(rate, 0)) {
            rate = 0;
        }
        return class_2561.method_43470(format.format(rate).replace("\u00A0", " "));
    }

    public void itemReceived(DisplayLinkBlockEntity be, int amount) {
        if (be.method_11010().method_61767(DisplayLinkBlock.POWERED, true))
            return;

        class_2487 conf = be.getSourceConfig();
        long gameTime = be.method_10997().method_75260();

        if (!conf.method_10545("LastReceived")) {
            conf.method_10544("LastReceived", gameTime);
            return;
        }

        long previousTime = conf.method_68080("LastReceived", 0);
        class_2499 rates = conf.method_68569("PrevRates");

        if (rates.size() != POOL_SIZE) {
            rates = new class_2499();
            for (int i = 0; i < POOL_SIZE; i++)
                rates.add(class_2494.method_23244(-1));
        }

        int poolIndex = conf.method_68083("Index", 0) % POOL_SIZE;
        rates.method_68585(poolIndex, class_2494.method_23244((float) (amount / (double) (gameTime - previousTime))));

        float rate = 0;
        int validIntervals = 0;
        for (int i = 0; i < POOL_SIZE; i++) {
            float pooledRate = rates.method_68575(i, 0);
            if (pooledRate >= 0) {
                rate += pooledRate;
                validIntervals++;
            }
        }

        conf.method_10551("Rate");
        if (validIntervals > 0) {
            rate /= validIntervals;
            conf.method_10548("Rate", rate);
        }

        conf.method_10551("Inactive");
        conf.method_10569("LastReceivedAmount", amount);
        conf.method_10544("LastReceived", gameTime);
        conf.method_10569("Index", poolIndex + 1);
        conf.method_10566("PrevRates", rates);
        be.updateGatheredData();
    }

    @Override
    protected String getTranslationKey() {
        return "item_throughput";
    }

}