package com.zurrtum.create.content.redstone.displayLink.target;

import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class NixieTubeDisplayTarget extends SingleLineDisplayTarget {

    @Override
    protected void acceptLine(class_5250 text, DisplayLinkContext context) {
        NixieTubeBlock.walkNixies(
            context.level(), context.getTargetPos(), false, (currentPos, rowPosition) -> {
                class_2586 blockEntity = context.level().method_8321(currentPos);
                if (blockEntity instanceof NixieTubeBlockEntity nixie)
                    nixie.displayCustomText(text, rowPosition);
            }
        );
    }

    @Override
    protected int getWidth(DisplayLinkContext context) {
        MutableInt count = new MutableInt(0);
        NixieTubeBlock.walkNixies(context.level(), context.getTargetPos(), false, (currentPos, rowPosition) -> count.add(2));
        return count.intValue();
    }

    public class_238 getMultiblockBounds(class_1936 level, class_2338 pos) {
        MutableObject<class_2338> start = new MutableObject<>(null);
        MutableObject<class_2338> end = new MutableObject<>(null);
        NixieTubeBlock.walkNixies(
            level, pos, true, (currentPos, rowPosition) -> {
                end.setValue(currentPos);
                if (start.getValue() == null)
                    start.setValue(currentPos);
            }
        );

        class_2338 diffToCurrent = start.getValue().method_10059(pos);
        class_2338 diff = end.getValue().method_10059(start.getValue());

        return super.getMultiblockBounds(level, pos).method_996(diffToCurrent).method_18804(class_243.method_24954(diff));
    }
}
