package com.zurrtum.create.content.redstone.link.controller;

import com.zurrtum.create.*;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5134;
import net.minecraft.class_9288;

public class LecternControllerBlockEntity extends SmartBlockEntity {
    private class_9288 controllerData = class_9288.field_49334;
    public UUID user;
    public UUID prevUser;    // used only on client
    private boolean deactivatedThisTick;    // used only on server

    public LecternControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.LECTERN_CONTROLLER, pos, state);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        dropController(state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("ControllerData", class_9288.field_49335, controllerData);
        if (user != null)
            view.method_71468("User", class_4844.field_25122, user);
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71468("ControllerData", class_9288.field_49335, controllerData);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        controllerData = view.method_71426("ControllerData", class_9288.field_49335).orElse(class_9288.field_49334);
        user = view.method_71426("User", class_4844.field_25122).orElse(null);
    }

    public class_1799 getController() {
        return createLinkedController();
    }

    public boolean hasUser() {
        return user != null;
    }

    public boolean isUsedBy(class_1657 player) {
        return hasUser() && user.equals(player.method_5667());
    }

    public void tryStartUsing(class_1657 player) {
        if (!deactivatedThisTick && !hasUser() && !playerIsUsingLectern(player) && playerInRange(player, field_11863, field_11867))
            startUsing(player);
    }

    public void tryStopUsing(class_1657 player) {
        if (isUsedBy(player))
            stopUsing(player);
    }

    private void startUsing(class_1657 player) {
        user = player.method_5667();
        AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.set(player, true);
        sendData();
    }

    private void stopUsing(class_1657 player) {
        user = null;
        if (player != null)
            AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.set(player, false);
        deactivatedThisTick = true;
        sendData();
    }

    public static boolean playerIsUsingLectern(class_1657 player) {
        return AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.get(player);
    }

    @Override
    public void tick() {
        super.tick();

        if (field_11863.method_8608()) {
            AllClientHandle.INSTANCE.tryToggleActive(this);
            prevUser = user;
        }

        if (!field_11863.method_8608()) {
            deactivatedThisTick = false;

            if (!(field_11863 instanceof class_3218))
                return;
            if (user == null)
                return;

            class_1297 entity = field_11863.method_66347(user);
            if (!(entity instanceof class_1657 player)) {
                stopUsing(null);
                return;
            }

            if (!playerInRange(player, field_11863, field_11867) || !playerIsUsingLectern(player))
                stopUsing(player);
        }
    }

    public void setController(class_1799 newController) {
        if (newController != null) {
            controllerData = newController.method_58695(AllDataComponents.LINKED_CONTROLLER_ITEMS, class_9288.field_49334);
            AllSoundEvents.CONTROLLER_PUT.playOnServer(field_11863, field_11867);
        }
    }

    public void swapControllers(class_1799 stack, class_1657 player, class_1268 hand, class_2680 state) {
        class_1799 newController = stack.method_7972();
        stack.method_7939(0);
        if (player.method_5998(hand).method_7960()) {
            player.method_6122(hand, createLinkedController());
        } else {
            dropController(state);
        }
        setController(newController);
    }

    public void dropController(class_2680 state) {
        class_1297 entity = field_11863.method_66347(user);
        if (entity instanceof class_1657 player)
            stopUsing(player);

        class_2350 dir = state.method_11654(LecternControllerBlock.field_16404);
        double x = field_11867.method_10263() + 0.5 + 0.25 * dir.method_10148();
        double y = field_11867.method_10264() + 1;
        double z = field_11867.method_10260() + 0.5 + 0.25 * dir.method_10165();
        class_1542 itementity = new class_1542(field_11863, x, y, z, createLinkedController());
        itementity.method_6988();
        field_11863.method_8649(itementity);
        controllerData = class_9288.field_49334;
    }

    public static boolean playerInRange(class_1657 player, class_1937 world, class_2338 pos) {
        //double modifier = world.isRemote ? 0 : 1.0;
        double reach = 0.4 * player.method_45325(class_5134.field_47758);// + modifier;
        return player.method_5707(class_243.method_24953(pos)) < reach * reach;
    }

    private class_1799 createLinkedController() {
        class_1799 stack = AllItems.LINKED_CONTROLLER.method_7854();
        stack.method_57379(AllDataComponents.LINKED_CONTROLLER_ITEMS, controllerData);
        return stack;
    }
}
