package com.zurrtum.create.content.redstone.nixieTube;

import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import net.minecraft.class_1750;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_3542;

public class DoubleFaceAttachedBlock extends class_2383 {

    public static final MapCodec<DoubleFaceAttachedBlock> field_46280 = method_54094(DoubleFaceAttachedBlock::new);

    public enum DoubleAttachFace implements class_3542 {
        FLOOR,
        WALL,
        WALL_REVERSED,
        CEILING;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }

        public int xRot() {
            return this == FLOOR ? 0 : this == CEILING ? 180 : 90;
        }
    }

    public static final class_2754<NixieTubeBlock.DoubleAttachFace> FACE = class_2754.method_11850(
        "double_face",
        NixieTubeBlock.DoubleAttachFace.class
    );

    public DoubleFaceAttachedBlock(class_2251 p_53182_) {
        super(p_53182_);
    }

    @Nullable
    public class_2680 method_9605(class_1750 pContext) {
        for (class_2350 direction : pContext.method_7718()) {
            class_2680 blockstate;
            if (direction.method_10166() == class_2350.class_2351.field_11052) {
                blockstate = method_9564().method_11657(
                    FACE,
                    direction == class_2350.field_11036 ? NixieTubeBlock.DoubleAttachFace.CEILING : NixieTubeBlock.DoubleAttachFace.FLOOR
                ).method_11657(field_11177, pContext.method_8042());
            } else {
                class_243 n = class_243.method_24954(direction.method_10170().method_62675());
                NixieTubeBlock.DoubleAttachFace face = NixieTubeBlock.DoubleAttachFace.WALL;
                if (pContext.method_8036() != null) {
                    class_243 lookAngle = pContext.method_8036().method_5720();
                    if (lookAngle.method_1026(n) < 0)
                        face = NixieTubeBlock.DoubleAttachFace.WALL_REVERSED;
                }
                blockstate = method_9564().method_11657(FACE, face).method_11657(field_11177, direction.method_10153());
            }

            if (blockstate.method_26184(pContext.method_8045(), pContext.method_8037())) {
                return blockstate;
            }
        }

        return null;
    }

    protected static class_2350 getConnectedDirection(class_2680 pState) {
        switch ((DoubleAttachFace) pState.method_11654(FACE)) {
            case CEILING:
                return class_2350.field_11033;
            case FLOOR:
                return class_2350.field_11036;
            default:
                return pState.method_11654(field_11177);
        }
    }

    @Override
    protected @NotNull MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }
}
