package com.zurrtum.create.content.schematics.cannon;

import com.google.common.collect.Sets;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public class MaterialChecklist {

    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public static final int MAX_ENTRIES_PER_CLIPBOARD_PAGE = 7;

    public Object2IntMap<class_1792> gathered = new Object2IntArrayMap<>();
    public Object2IntMap<class_1792> required = new Object2IntArrayMap<>();
    public Object2IntMap<class_1792> damageRequired = new Object2IntArrayMap<>();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty())
            return;
        if (requirement.isInvalid())
            return;

        for (ItemRequirement.StackRequirement stack : requirement.getRequiredItems()) {
            if (stack.usage == ItemUseType.DAMAGE)
                putOrIncrement(damageRequired, stack.stack);
            if (stack.usage == ItemUseType.CONSUME)
                putOrIncrement(required, stack.stack);
        }
    }

    private void putOrIncrement(Object2IntMap<class_1792> map, class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8162)
            return;
        if (map.containsKey(item))
            map.put(item, map.getInt(item) + stack.method_7947());
        else
            map.put(item, stack.method_7947());
    }

    public void collect(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (required.containsKey(item) || damageRequired.containsKey(item))
            if (gathered.containsKey(item))
                gathered.put(item, gathered.getInt(item) + stack.method_7947());
            else
                gathered.put(item, stack.method_7947());
    }

    public class_1799 createWrittenBook() {
        class_1799 book = new class_1799(class_1802.field_8360);

        List<class_9262<class_2561>> pages = new ArrayList<>();

        int itemsWritten = 0;
        class_5250 textComponent;

        if (blocksNotLoaded) {
            textComponent = class_2561.method_43470("\n" + class_124.field_1061);
            textComponent = textComponent.method_10852(class_2561.method_43471("create.materialChecklist.blocksNotLoaded"));
            pages.add(class_9262.method_57137(textComponent));
        }

        List<class_1792> keys = new ArrayList<>(Sets.union(required.keySet(), damageRequired.keySet()));
        Collections.sort(
            keys, (item1, item2) -> {
                Locale locale = Locale.ENGLISH;
                String name1 = item1.method_63680().getString().toLowerCase(locale);
                String name2 = item2.method_63680().getString().toLowerCase(locale);
                return name1.compareTo(name2);
            }
        );

        textComponent = class_2561.method_43473();
        List<class_1792> completed = new ArrayList<>();
        for (class_1792 item : keys) {
            int amount = getRequiredAmount(item);
            if (gathered.containsKey(item))
                amount -= gathered.getInt(item);

            if (amount <= 0) {
                completed.add(item);
                continue;
            }

            if (itemsWritten == MAX_ENTRIES_PER_PAGE) {
                itemsWritten = 0;
                textComponent.method_10852(class_2561.method_43470("\n >>>").method_27692(class_124.field_1078));
                pages.add(class_9262.method_57137(textComponent));
                textComponent = class_2561.method_43473();
            }

            itemsWritten++;
            textComponent.method_10852(entry(new class_1799(item), amount, true, true));
        }

        for (class_1792 item : completed) {
            if (itemsWritten == MAX_ENTRIES_PER_PAGE) {
                itemsWritten = 0;
                textComponent.method_10852(class_2561.method_43470("\n >>>").method_27692(class_124.field_1077));
                pages.add(class_9262.method_57137(textComponent));
                textComponent = class_2561.method_43473();
            }

            itemsWritten++;
            textComponent.method_10852(entry(new class_1799(item), getRequiredAmount(item), false, true));
        }

        pages.add(class_9262.method_57137(textComponent));

        class_9302 contents = new class_9302(
            class_9262.method_57137(class_124.field_1078 + "Material Checklist"),
            "Schematicannon",
            0,
            pages,
            true
        );
        book.method_57379(class_9334.field_49606, contents);
        textComponent = class_2561.method_43471("create.materialChecklist")
            .method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_10978(Boolean.FALSE));
        book.method_57379(class_9334.field_49631, textComponent);

        return book;
    }

    public class_1799 createWrittenClipboard() {
        int itemsWritten = 0;

        List<List<ClipboardEntry>> pages = new ArrayList<>();
        List<ClipboardEntry> currentPage = new ArrayList<>();

        if (blocksNotLoaded) {
            currentPage.add(new ClipboardEntry(
                false,
                class_2561.method_43471("create.materialChecklist.blocksNotLoaded").method_27692(class_124.field_1061)
            ));
        }

        List<class_1792> keys = new ArrayList<>(Sets.union(required.keySet(), damageRequired.keySet()));
        keys.sort((item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.method_63680().getString().toLowerCase(locale);
            String name2 = item2.method_63680().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });

        List<class_1792> completed = new ArrayList<>();
        for (class_1792 item : keys) {
            int amount = getRequiredAmount(item);
            if (gathered.containsKey(item))
                amount -= gathered.getInt(item);

            if (amount <= 0) {
                completed.add(item);
                continue;
            }

            if (itemsWritten == MAX_ENTRIES_PER_CLIPBOARD_PAGE) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(false, class_2561.method_43470(">>>").method_27692(class_124.field_1063)));
                pages.add(currentPage);
                currentPage = new ArrayList<>();
            }

            itemsWritten++;
            currentPage.add(new ClipboardEntry(false, entry(new class_1799(item), amount, true, false)).displayItem(new class_1799(item), amount));
        }

        for (class_1792 item : completed) {
            if (itemsWritten == MAX_ENTRIES_PER_CLIPBOARD_PAGE) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(true, class_2561.method_43470(">>>").method_27692(class_124.field_1077)));
                pages.add(currentPage);
                currentPage = new ArrayList<>();
            }

            itemsWritten++;
            currentPage.add(new ClipboardEntry(
                true,
                entry(new class_1799(item), getRequiredAmount(item), false, false)
            ).displayItem(new class_1799(item), 0));
        }

        pages.add(currentPage);

        class_1799 clipboard = AllItems.CLIPBOARD.method_7854();
        clipboard.method_57379(AllDataComponents.CLIPBOARD_CONTENT, new ClipboardContent(ClipboardType.WRITTEN, pages, true));
        clipboard.method_57379(class_9334.field_49631, class_2561.method_43471("create.materialChecklist").method_10862(class_2583.field_24360.method_10978(false)));
        return clipboard;
    }

    public int getRequiredAmount(class_1792 item) {
        int amount = required.getOrDefault(item, 0);
        if (damageRequired.containsKey(item))
            amount += (int) Math.ceil(damageRequired.getInt(item) / (float) new class_1799(item).method_7936());
        return amount;
    }

    private class_5250 entry(class_1799 item, int amount, boolean unfinished, boolean forBook) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        class_5250 tc = class_2561.method_43473();
        tc.method_10852(class_2561.method_43471(item.method_7909().method_7876()).method_10862(class_2583.field_24360.method_10949(new class_2568.class_10612(item))));

        if (!unfinished && forBook)
            tc.method_27693(" ✔");
        if (!unfinished || forBook)
            tc.method_27692(unfinished ? class_124.field_1078 : class_124.field_1077);
        return tc.method_10852(class_2561.method_43470("\n" + " x" + amount).method_27692(class_124.field_1074))
            .method_10852(class_2561.method_43470(" | " + stacks + "▤ +" + remainder + (forBook ? "\n" : "")).method_27692(class_124.field_1080));
    }

}
