package com.zurrtum.create.content.schematics.cannon;

import com.mojang.serialization.Codec;
import com.zurrtum.create.*;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity.CasingType;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.zurrtum.create.content.schematics.SchematicPrinter;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SchematicannonOptions;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.config.CSchematics;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9323.class_9324;
import net.minecraft.class_9473;

public class SchematicannonBlockEntity extends SmartBlockEntity implements MenuProvider {

    public static final int NEIGHBOUR_CHECKING = 100;
    public static final int MAX_ANCHOR_DISTANCE = 256;

    // Inventory
    public SchematicannonInventory inventory;

    public boolean sendUpdate;
    // Sync
    public boolean dontUpdateChecklist;
    public int neighbourCheckCooldown;

    // Printer
    public SchematicPrinter printer;
    public class_1799 missingItem;
    public boolean positionNotLoaded;
    public boolean hasCreativeCrate;
    private int printerCooldown;
    private int skipsLeft;
    private boolean blockSkipped;

    public class_2338 previousTarget;
    public LinkedHashSet<class_1263> attachedInventories;
    public List<LaunchedItem> flyingBlocks;
    public MaterialChecklist checklist;

    // Gui information
    public int remainingFuel;
    public float bookPrintingProgress;
    public float schematicProgress;
    public String statusMsg;
    public State state;
    public int blocksPlaced;
    public int blocksToPlace;

    // Settings
    public int replaceMode;
    public boolean skipMissing;
    public boolean replaceBlockEntities;

    // Render
    public boolean firstRenderTick;
    public float defaultYaw;

    public SchematicannonBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SCHEMATICANNON, pos, state);
        setLazyTickRate(30);
        attachedInventories = new LinkedHashSet<>();
        flyingBlocks = new LinkedList<>();
        inventory = new SchematicannonInventory(this);
        statusMsg = "idle";
        this.state = State.STOPPED;
        replaceMode = 2;
        checklist = new MaterialChecklist();
        printer = new SchematicPrinter();
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1264.method_5451(field_11863, pos, inventory);
    }

    public void findInventories() {
        hasCreativeCrate = false;
        attachedInventories.clear();
        for (class_2350 facing : Iterate.directions) {

            class_2338 target = field_11867.method_10093(facing);
            if (!field_11863.method_8477(target))
                continue;

            class_2680 state = field_11863.method_8320(target);
            if (state.method_27852(AllBlocks.CREATIVE_CRATE))
                hasCreativeCrate = true;

            class_2586 blockEntity = field_11863.method_8321(target);
            if (blockEntity != null) {
                class_1263 capability = ItemHelper.getInventory(field_11863, target, state, blockEntity, facing);
                if (capability != null) {
                    attachedInventories.add(capability);
                }
            }
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        if (!clientPacket) {
            inventory.read(view);
        }

        // Gui information
        statusMsg = view.method_71428("Status", "");
        schematicProgress = view.method_71423("Progress", 0);
        bookPrintingProgress = view.method_71423("PaperProgress", 0);
        remainingFuel = view.method_71424("RemainingFuel", 0);
        state = view.method_71426("State", State.CODEC).orElse(State.STOPPED);
        blocksPlaced = view.method_71424("AmountPlaced", 0);
        blocksToPlace = view.method_71424("AmountToPlace", 0);

        missingItem = null;
        view.method_71426("MissingItem", class_1799.field_49266).ifPresent(item -> missingItem = item);

        // Settings
        view.method_71426("Options", SchematicannonOptions.CODEC).ifPresentOrElse(
            options -> {
                replaceMode = options.replaceMode();
                skipMissing = options.skipMissing();
                replaceBlockEntities = options.replaceBlockEntities();
            }, () -> {
                replaceMode = 2;
                skipMissing = true;
                replaceBlockEntities = false;
            }
        );

        // Printer & Flying Blocks
        view.method_71420("Printer").ifPresent(data -> printer.read(data, clientPacket));
        view.method_71436("FlyingBlocks").ifPresent(this::readFlyingBlocks);

        defaultYaw = view.method_71423("DefaultYaw", 0);

        super.read(view, clientPacket);
    }

    protected void readFlyingBlocks(class_11368.class_11370 list) {
        if (list.method_71444()) {
            flyingBlocks.clear();
            return;
        }

        boolean pastDead = false;
        int i = -1;
        for (class_11368 item : list) {
            i++;
            LaunchedItem launched = LaunchedItem.from(item, blockHolderGetter());
            class_2338 readBlockPos = launched.target;

            // Always write to Server block entity
            if (field_11863 == null || !field_11863.method_8608()) {
                flyingBlocks.add(launched);
                continue;
            }

            // Delete all Client side blocks that are now missing on the server
            while (!pastDead && !flyingBlocks.isEmpty() && !flyingBlocks.getFirst().target.equals(readBlockPos)) {
                flyingBlocks.removeFirst();
            }

            pastDead = true;

            // Add new server side blocks
            if (i >= flyingBlocks.size()) {
                flyingBlocks.add(launched);
            }

            // Don't do anything with existing
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (!clientPacket) {
            inventory.write(view);
            if (state == State.RUNNING) {
                view.method_71472("Running", true);
            }
        }

        // Gui information
        view.method_71464("Progress", schematicProgress);
        view.method_71464("PaperProgress", bookPrintingProgress);
        view.method_71465("RemainingFuel", remainingFuel);
        view.method_71469("Status", statusMsg);
        view.method_71468("State", State.CODEC, state);
        view.method_71465("AmountPlaced", blocksPlaced);
        view.method_71465("AmountToPlace", blocksToPlace);

        if (missingItem != null)
            view.method_71468("MissingItem", class_1799.field_49266, missingItem);

        // Settings
        view.method_71468("Options", SchematicannonOptions.CODEC, new SchematicannonOptions(replaceMode, skipMissing, replaceBlockEntities));

        // Printer & Flying Blocks
        printer.write(view.method_71461("Printer"));

        class_11372.class_11374 blocks = view.method_71476("FlyingBlocks");
        for (LaunchedItem b : flyingBlocks)
            b.write(blocks.method_71480());

        view.method_71464("DefaultYaw", defaultYaw);

        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();

        if (state != State.STOPPED && neighbourCheckCooldown-- <= 0) {
            neighbourCheckCooldown = NEIGHBOUR_CHECKING;
            findInventories();
        }

        firstRenderTick = true;
        previousTarget = printer.getCurrentTarget();
        tickFlyingBlocks();

        if (field_11863.method_8608())
            return;

        // Update Fuel and Paper
        tickPaperPrinter();
        refillFuelIfPossible();

        // Update Printer
        skipsLeft = 1000;
        blockSkipped = true;

        while (blockSkipped && skipsLeft-- > 0)
            tickPrinter();

        schematicProgress = 0;
        if (blocksToPlace > 0)
            schematicProgress = (float) blocksPlaced / blocksToPlace;

        // Update Client block entity
        if (sendUpdate) {
            sendUpdate = false;
            field_11863.method_8413(field_11867, method_11010(), method_11010(), 6);
        }
    }

    public CSchematics config() {
        return AllConfigs.server().schematics;
    }

    protected void tickPrinter() {
        class_1799 blueprint = inventory.method_5438(0);
        blockSkipped = false;

        if (blueprint.method_7960() && !statusMsg.equals("idle") && inventory.method_5438(1).method_7960()) {
            state = State.STOPPED;
            statusMsg = "idle";
            sendUpdate = true;
            return;
        }

        // Skip if not Active
        if (state == State.STOPPED) {
            if (printer.isLoaded())
                resetPrinter();
            return;
        }

        if (state == State.PAUSED && !positionNotLoaded && missingItem == null && remainingFuel > 0)
            return;

        // Initialize Printer
        if (!printer.isLoaded()) {
            initializePrinter(blueprint);
            return;
        }

        // Cooldown from last shot
        if (printerCooldown > 0) {
            printerCooldown--;
            return;
        }

        // Check Fuel
        if (remainingFuel <= 0 && !hasCreativeCrate) {
            refillFuelIfPossible();
            if (remainingFuel <= 0) {
                state = State.PAUSED;
                statusMsg = "noGunpowder";
                sendUpdate = true;
                return;
            }
        }

        if (hasCreativeCrate) {
            remainingFuel = 0;
            if (missingItem != null) {
                missingItem = null;
                state = State.RUNNING;
            }
        }

        // Update Target
        if (missingItem == null && !positionNotLoaded) {
            if (!printer.advanceCurrentPos()) {
                finishedPrinting();
                return;
            }
            sendUpdate = true;
        }

        // Check block
        if (!field_11863.method_8477(printer.getCurrentTarget())) {
            positionNotLoaded = true;
            statusMsg = "targetNotLoaded";
            state = State.PAUSED;
            return;
        } else {
            if (positionNotLoaded) {
                positionNotLoaded = false;
                state = State.RUNNING;
            }
        }

        // Get item requirement
        ItemRequirement requirement = printer.getCurrentRequirement();
        if (requirement.isInvalid() || !printer.shouldPlaceCurrent(field_11863, this::shouldPlace)) {
            sendUpdate = !statusMsg.equals("searching");
            statusMsg = "searching";
            blockSkipped = true;
            return;
        }

        // Find item
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        if (!requirement.isEmpty()) {
            for (ItemRequirement.StackRequirement required : requiredItems) {
                if (!grabItemsFromAttachedInventories(required, true)) {
                    if (skipMissing) {
                        statusMsg = "skipping";
                        blockSkipped = true;
                        if (missingItem != null) {
                            missingItem = null;
                            state = State.RUNNING;
                        }
                        return;
                    }

                    missingItem = required.stack;
                    state = State.PAUSED;
                    statusMsg = "missingBlock";
                    return;
                }
            }

            for (ItemRequirement.StackRequirement required : requiredItems)
                grabItemsFromAttachedInventories(required, false);
        }

        // Success
        state = State.RUNNING;
        class_1799 icon = requirement.isEmpty() || requiredItems.isEmpty() ? class_1799.field_8037 : requiredItems.get(0).stack;
        printer.handleCurrentTarget(
            (target, blockState, blockEntity) -> {
                // Launch block
                statusMsg = blockState.method_26204() != class_2246.field_10124 ? "placing" : "clearing";
                launchBlockOrBelt(target, icon, blockState, blockEntity);
            }, (target, entity) -> {
                // Launch entity
                statusMsg = "placing";
                launchEntity(target, icon, entity);
            }
        );

        printerCooldown = config().schematicannonDelay.get();
        remainingFuel -= 1;
        sendUpdate = true;
        missingItem = null;
    }

    public int getShotsPerGunpowder() {
        return hasCreativeCrate ? 0 : config().schematicannonShotsPerGunpowder.get();
    }

    protected void initializePrinter(class_1799 blueprint) {
        if (!blueprint.method_57826(AllDataComponents.SCHEMATIC_ANCHOR)) {
            state = State.STOPPED;
            statusMsg = "schematicInvalid";
            sendUpdate = true;
            return;
        }

        if (!blueprint.method_58695(AllDataComponents.SCHEMATIC_DEPLOYED, false)) {
            state = State.STOPPED;
            statusMsg = "schematicNotPlaced";
            sendUpdate = true;
            return;
        }

        // Load blocks into reader
        printer.loadSchematic(blueprint, field_11863, true);

        if (printer.isErrored()) {
            state = State.STOPPED;
            statusMsg = "schematicErrored";
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, AllItems.EMPTY_SCHEMATIC.method_7854());
            printer.resetSchematic();
            sendUpdate = true;
            return;
        }

        if (printer.isWorldEmpty()) {
            state = State.STOPPED;
            statusMsg = "schematicExpired";
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, AllItems.EMPTY_SCHEMATIC.method_7854());
            printer.resetSchematic();
            sendUpdate = true;
            return;
        }

        if (!printer.getAnchor().method_19771(method_11016(), MAX_ANCHOR_DISTANCE)) {
            state = State.STOPPED;
            statusMsg = "targetOutsideRange";
            printer.resetSchematic();
            sendUpdate = true;
            return;
        }

        state = State.PAUSED;
        statusMsg = "ready";
        updateChecklist();
        sendUpdate = true;
        blocksToPlace += blocksPlaced;
    }

    protected class_1799 getItemForBlock(class_2680 blockState) {
        class_1792 item = blockState.method_26204().method_8389();
        return item == class_1802.field_8162 ? class_1799.field_8037 : item.method_7854();
    }

    protected boolean grabItemsFromAttachedInventories(ItemRequirement.StackRequirement required, boolean simulate) {
        if (hasCreativeCrate)
            return true;

        attachedInventories.removeIf(Objects::isNull);

        ItemUseType usage = required.usage;

        // Find and apply damage
        if (usage == ItemUseType.DAMAGE) {
            for (class_1263 cap : attachedInventories) {
                if (cap == null) {
                    continue;
                }
                if (simulate) {
                    if (!cap.count(stack -> required.matches(stack) && stack.method_7963(), 1).method_7960()) {
                        return true;
                    }
                } else {
                    if (cap.update(
                        stack -> required.matches(stack) && stack.method_7963(), stack -> {
                            int damage = stack.method_7919() + 1;
                            int maxDamage = stack.method_7936();
                            if (damage >= maxDamage) {
                                return class_1799.field_8037;
                            }
                            stack.method_7974(damage);
                            return stack;
                        }
                    )) {
                        return true;
                    }
                }
            }

            return false;
        }

        // Find and remove
        int remaining = required.stack.method_7947();
        for (class_1263 cap : attachedInventories) {
            if (cap == null) {
                continue;
            }
            remaining -= cap.countAll(required::matches, remaining);
            if (remaining == 0) {
                break;
            }
        }

        boolean success = remaining == 0;
        if (!simulate && success) {
            remaining = required.stack.method_7947();
            for (class_1263 cap : attachedInventories) {
                if (cap == null) {
                    continue;
                }
                remaining -= cap.extractAll(required::matches, remaining);
                if (remaining == 0) {
                    break;
                }
            }
        }

        return success;
    }

    public void finishedPrinting() {
        if (replaceMode == ConfigureSchematicannonPacket.Option.REPLACE_EMPTY.ordinal())
            printer.sendBlockUpdates(field_11863);
        inventory.method_5447(0, class_1799.field_8037);
        inventory.method_5447(1, new class_1799(AllItems.EMPTY_SCHEMATIC, inventory.method_5438(1).method_7947() + 1));
        state = State.STOPPED;
        statusMsg = "finished";
        resetPrinter();
        AllSoundEvents.SCHEMATICANNON_FINISH.playOnServer(field_11863, field_11867);
        sendUpdate = true;
    }

    protected void resetPrinter() {
        printer.resetSchematic();
        missingItem = null;
        sendUpdate = true;
        schematicProgress = 0;
        blocksPlaced = 0;
        blocksToPlace = 0;
    }

    protected boolean shouldPlace(
        class_2338 pos,
        class_2680 state,
        class_2586 be,
        class_2680 toReplace,
        class_2680 toReplaceOther,
        boolean isNormalCube
    ) {
        if (pos.method_19771(method_11016(), 2f))
            return false;
        if (!replaceBlockEntities && (toReplace.method_31709() || (toReplaceOther != null && toReplaceOther.method_31709())))
            return false;

        if (shouldIgnoreBlockState(state, be))
            return false;

        boolean placingAir = state.method_26215();

        if (replaceMode == 3)
            return true;
        if (replaceMode == 2 && !placingAir)
            return true;
        if (replaceMode == 1 && (isNormalCube || (!toReplace.method_26212(
            field_11863,
            pos
        ) && (toReplaceOther == null || !toReplaceOther.method_26212(field_11863, pos)))) && !placingAir)
            return true;
        return replaceMode == 0 && !toReplace.method_26212(field_11863, pos) && (toReplaceOther == null || !toReplaceOther.method_26212(
            field_11863,
            pos
        )) && !placingAir;
    }

    protected boolean shouldIgnoreBlockState(class_2680 state, class_2586 be) {
        // Block doesn't have a mapping (Water, lava, etc)
        if (state.method_26204() == class_2246.field_10369)
            return true;

        ItemRequirement requirement = ItemRequirement.of(state, be);
        if (requirement.isEmpty())
            return false;
        if (requirement.isInvalid())
            return false;

        // Block doesn't need to be placed twice (Doors, beds, double plants)
        if (state.method_28498(class_2741.field_12533) && state.method_11654(class_2741.field_12533) == class_2756.field_12609)
            return true;
        if (state.method_28498(class_2741.field_12483) && state.method_11654(class_2741.field_12483) == class_2742.field_12560)
            return true;
        if (state.method_26204() instanceof class_2671)
            return true;
        if (state.method_27852(AllBlocks.BELT))
            return state.method_11654(BeltBlock.PART) == BeltPart.MIDDLE;

        return false;
    }

    protected void tickFlyingBlocks() {
        List<LaunchedItem> toRemove = new LinkedList<>();
        for (LaunchedItem b : flyingBlocks)
            if (b.update(field_11863))
                toRemove.add(b);
        flyingBlocks.removeAll(toRemove);
    }

    protected void refillFuelIfPossible() {
        if (hasCreativeCrate)
            return;
        if (remainingFuel > getShotsPerGunpowder()) {
            remainingFuel = getShotsPerGunpowder();
            sendUpdate = true;
            return;
        }

        if (remainingFuel > 0)
            return;

        class_1799 gunpowder = inventory.method_5438(4);
        if (!gunpowder.method_7960()) {
            gunpowder.method_7934(1);
        } else {
            boolean externalGunpowderFound = false;
            for (class_1263 cap : attachedInventories) {
                if (cap == null) {
                    continue;
                }
                if (cap.extractAll(stack -> inventory.method_5437(4, stack), 1) == 0)
                    continue;
                externalGunpowderFound = true;
                break;
            }
            if (!externalGunpowderFound)
                return;
        }

        remainingFuel += getShotsPerGunpowder();
        if (statusMsg.equals("noGunpowder")) {
            if (blocksPlaced > 0)
                state = State.RUNNING;
            statusMsg = "ready";
        }
        sendUpdate = true;
    }

    protected void tickPaperPrinter() {
        int BookInput = 2;
        int BookOutput = 3;

        class_1799 blueprint = inventory.method_5438(0);
        class_1799 paper = inventory.method_5438(BookInput);
        class_1799 output = inventory.method_5438(BookOutput);
        boolean outputFull = output.method_7947() == output.method_7914();

        if (printer.isErrored())
            return;

        if (!printer.isLoaded()) {
            if (!blueprint.method_7960())
                initializePrinter(blueprint);
            return;
        }

        if (paper.method_7960() || outputFull) {
            if (bookPrintingProgress != 0)
                sendUpdate = true;
            bookPrintingProgress = 0;
            dontUpdateChecklist = false;
            return;
        }

        if (bookPrintingProgress >= 1) {
            bookPrintingProgress = 0;

            if (!dontUpdateChecklist)
                updateChecklist();

            dontUpdateChecklist = true;
            inventory.method_5447(BookInput, class_1799.field_8037);
            class_1799 stack = paper.method_31574(AllItems.CLIPBOARD) ? checklist.createWrittenClipboard() : checklist.createWrittenBook();
            stack.method_7939(inventory.method_5438(BookOutput).method_7947() + 1);
            inventory.method_5447(BookOutput, stack);
            inventory.method_5431();
            sendUpdate = true;
            return;
        }

        bookPrintingProgress += 0.05f;
        sendUpdate = true;
    }

    public static class_2680 stripBeltIfNotLast(class_2680 blockState) {
        BeltPart part = blockState.method_11654(BeltBlock.PART);
        if (part == BeltPart.MIDDLE)
            return class_2246.field_10124.method_9564();

        // is highest belt?
        boolean isLastSegment = false;
        class_2350 facing = blockState.method_11654(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = blockState.method_11654(BeltBlock.SLOPE);
        boolean positive = facing.method_10171() == class_2352.field_11056;
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;

        switch (slope) {
            case DOWNWARD:
                isLastSegment = start;
                break;
            case UPWARD:
                isLastSegment = end;
                break;
            default:
                isLastSegment = positive && end || !positive && start;
        }
        if (isLastSegment)
            return blockState;

        return AllBlocks.SHAFT.method_9564()
            .method_11657(AbstractSimpleShaftBlock.AXIS, slope == BeltSlope.SIDEWAYS ? class_2351.field_11052 : facing.method_10170().method_10166());
    }

    protected void launchBlockOrBelt(class_2338 target, class_1799 icon, class_2680 blockState, class_2586 blockEntity) {
        if (blockState.method_27852(AllBlocks.BELT)) {
            blockState = stripBeltIfNotLast(blockState);
            if (blockEntity instanceof BeltBlockEntity bbe && blockState.method_27852(AllBlocks.BELT)) {
                CasingType[] casings = new CasingType[bbe.beltLength];
                Arrays.fill(casings, CasingType.NONE);
                class_2338 currentPos = target;
                for (int i = 0; i < bbe.beltLength; i++) {
                    class_2680 currentState = bbe.method_10997().method_8320(currentPos);
                    if (!(currentState.method_26204() instanceof BeltBlock))
                        break;
                    if (!(bbe.method_10997().method_8321(currentPos) instanceof BeltBlockEntity beltAtSegment))
                        break;
                    casings[i] = beltAtSegment.casing;
                    currentPos = BeltBlock.nextSegmentPosition(currentState, currentPos, blockState.method_11654(BeltBlock.PART) != BeltPart.END);
                }
                launchBelt(target, blockState, bbe.beltLength, casings);
            } else if (blockState != class_2246.field_10124.method_9564())
                launchBlock(target, icon, blockState, null);
            return;
        }

        class_2487 data = BlockHelper.prepareBlockEntityData(field_11863, blockState, blockEntity);
        launchBlock(target, icon, blockState, data);
    }

    protected void launchBelt(class_2338 target, class_2680 state, int length, CasingType[] casings) {
        blocksPlaced++;
        class_1799 connector = AllItems.BELT_CONNECTOR.method_7854();
        flyingBlocks.add(new LaunchedItem.ForBelt(method_11016(), target, connector, state, casings));
        playFiringSound();
    }

    protected void launchBlock(class_2338 target, class_1799 stack, class_2680 state, @Nullable class_2487 data) {
        if (!state.method_26215())
            blocksPlaced++;
        flyingBlocks.add(new LaunchedItem.ForBlockState(method_11016(), target, stack, state, data));
        playFiringSound();
    }

    protected void launchEntity(class_2338 target, class_1799 stack, class_1297 entity) {
        blocksPlaced++;
        flyingBlocks.add(new LaunchedItem.ForEntity(method_11016(), target, stack, entity));
        playFiringSound();
    }

    public void playFiringSound() {
        AllSoundEvents.SCHEMATICANNON_LAUNCH_BLOCK.playOnServer(field_11863, field_11867);
    }

    @Override
    public SchematicannonMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        sendToMenu(extraData);
        return new SchematicannonMenu(id, inv, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471("create.gui.schematicannon.title");
    }

    public void updateChecklist() {
        checklist.required.clear();
        checklist.damageRequired.clear();
        checklist.blocksNotLoaded = false;

        if (printer.isLoaded() && !printer.isErrored()) {
            blocksToPlace = blocksPlaced;
            blocksToPlace += printer.markAllBlockRequirements(checklist, field_11863, this::shouldPlace);
            printer.markAllEntityRequirements(checklist);
        }

        checklist.gathered.clear();
        findInventories();
        for (class_1263 cap : attachedInventories) {
            if (cap == null)
                continue;
            for (class_1799 stack : cap) {
                checklist.collect(stack);
            }
        }
        sendUpdate = true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        findInventories();
    }

    //TODO
    //    @Override
    //    public AABB getRenderBoundingBox() {
    //        return AABB.INFINITE;
    //    }

    @Override
    protected void method_57568(class_9473 componentInput) {
        SchematicannonOptions options = componentInput.method_58695(
            AllDataComponents.SCHEMATICANNON_OPTIONS,
            new SchematicannonOptions(2, true, false)
        );
        replaceMode = options.replaceMode();
        skipMissing = options.skipMissing();
        replaceBlockEntities = options.replaceBlockEntities();
    }

    @Override
    protected void method_57567(class_9324 components) {
        components.method_57840(AllDataComponents.SCHEMATICANNON_OPTIONS, new SchematicannonOptions(replaceMode, skipMissing, replaceBlockEntities));
    }

    public enum State implements class_3542 {
        STOPPED,
        PAUSED,
        RUNNING;

        public static final Codec<State> CODEC = class_3542.method_28140(State::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }
}
