package com.zurrtum.create.content.trains.display;

import org.apache.commons.lang3.mutable.MutableInt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;

public class FlapDisplayLayout {
    List<FlapDisplaySection> sections;
    String layoutKey;

    public FlapDisplayLayout(int maxCharCount) {
        loadDefault(maxCharCount);
    }

    public void loadDefault(int maxCharCount) {
        configure("Default", Arrays.asList(new FlapDisplaySection(maxCharCount * FlapDisplaySection.MONOSPACE, "alphabet", false, false)));
    }

    public boolean isLayout(String key) {
        return layoutKey.equals(key);
    }

    public void configure(String layoutKey, List<FlapDisplaySection> sections) {
        this.layoutKey = layoutKey;
        this.sections = sections;
    }

    public void write(class_11372 view) {
        view.method_71469("Key", layoutKey);
        class_11372.class_11374 list = view.method_71476("Sections");
        sections.forEach(section -> section.write(list.method_71480()));
    }

    public void read(class_11368 view) {
        String prevKey = layoutKey;
        layoutKey = view.method_71428("Key", "");

        if (!prevKey.equals(layoutKey)) {
            sections = new ArrayList<>();
            view.method_71438("Sections").forEach(section -> sections.add(FlapDisplaySection.load(section)));
            return;
        }

        MutableInt index = new MutableInt(0);
        view.method_71438("Sections").forEach(section -> sections.get(index.getAndIncrement()).update(section));
    }

    public List<FlapDisplaySection> getSections() {
        return sections;
    }

}
