package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.*;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.graph.*;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class TrainMigration {

    Couple<TrackNodeLocation> locations;
    double positionOnOldEdge;
    boolean curve;
    class_243 fallback;

    public TrainMigration() {
    }

    public TrainMigration(TravellingPoint point) {
        double t = point.position / point.edge.getLength();
        fallback = point.edge.getPosition(null, t);
        curve = point.edge.isTurn();
        positionOnOldEdge = point.position;
        locations = Couple.create(point.node1.getLocation(), point.node2.getLocation());
    }

    public TrackGraphLocation tryMigratingTo(TrackGraph graph) {
        TrackNode node1 = graph.locateNode(locations.getFirst());
        TrackNode node2 = graph.locateNode(locations.getSecond());
        if (node1 != null && node2 != null) {
            TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
            if (edge != null) {
                TrackGraphLocation graphLocation = new TrackGraphLocation();
                graphLocation.graph = graph;
                graphLocation.edge = locations;
                graphLocation.position = positionOnOldEdge;
                return graphLocation;
            }
        }

        if (curve)
            return null;

        class_243 prevDirection = locations.getSecond().getLocation().method_1020(locations.getFirst().getLocation()).method_1029();

        for (TrackNodeLocation loc : graph.getNodes()) {
            class_243 nodeVec = loc.getLocation();
            if (nodeVec.method_1025(fallback) > 32 * 32)
                continue;

            TrackNode newNode1 = graph.locateNode(loc);
            for (Map.Entry<TrackNode, TrackEdge> entry : graph.getConnectionsFrom(newNode1).entrySet()) {
                TrackEdge edge = entry.getValue();
                if (edge.isTurn())
                    continue;
                TrackNode newNode2 = entry.getKey();
                float radius = 1 / 64f;
                class_243 direction = edge.getDirection(true);
                if (!class_3532.method_20390(direction.method_1026(prevDirection), 1))
                    continue;
                class_243 intersectSphere = VecHelper.intersectSphere(nodeVec, direction, fallback, radius);
                if (intersectSphere == null)
                    continue;
                if (!class_3532.method_20390(direction.method_1026(intersectSphere.method_1020(nodeVec).method_1029()), 1))
                    continue;
                double edgeLength = edge.getLength();
                double position = intersectSphere.method_1022(nodeVec) - radius;
                if (Double.isNaN(position))
                    continue;
                if (position < 0)
                    continue;
                if (position > edgeLength)
                    continue;

                TrackGraphLocation graphLocation = new TrackGraphLocation();
                graphLocation.graph = graph;
                graphLocation.edge = Couple.create(loc, newNode2.getLocation());
                graphLocation.position = position;
                return graphLocation;
            }
        }

        return null;
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71472("Curve", curve);
        view.method_71468("Fallback", class_243.field_38277, fallback);
        view.method_71463("Position", positionOnOldEdge);
        class_11372.class_11374 list = view.method_71476("Nodes");
        locations.getFirst().write(list.method_71480(), dimensions);
        locations.getSecond().write(list.method_71480(), dimensions);
    }

    public static <T> DataResult<T> encode(final TrainMigration input, final DynamicOps<T> ops, final T empty, DimensionPalette dimensions) {
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("Curve", ops.createBoolean(input.curve));
        map.add("Fallback", input.fallback, class_243.field_38277);
        map.add("Curve", ops.createDouble(input.positionOnOldEdge));
        ListBuilder<T> list = ops.listBuilder();
        list.add(TrackNodeLocation.encode(input.locations.getFirst(), ops, empty, dimensions));
        list.add(TrackNodeLocation.encode(input.locations.getSecond(), ops, empty, dimensions));
        map.add("Nodes", list.build(empty));
        return map.build(empty);
    }

    public static TrainMigration read(class_11368 view, DimensionPalette dimensions) {
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = view.method_71433("Curve", false);
        trainMigration.fallback = view.method_71426("Fallback", class_243.field_38277).orElse(class_243.field_1353);
        trainMigration.positionOnOldEdge = view.method_71422("Position", 0);
        Iterator<class_11368> iterator = view.method_71438("Nodes").iterator();
        trainMigration.locations = Couple.create(
            TrackNodeLocation.read(iterator.next(), dimensions),
            TrackNodeLocation.read(iterator.next(), dimensions)
        );
        return trainMigration;
    }

    public static <T> TrainMigration decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = ops.getBooleanValue(map.get("Curve")).result().orElse(false);
        trainMigration.fallback = class_243.field_38277.parse(ops, map.get("Fallback")).result().orElse(class_243.field_1353);
        trainMigration.positionOnOldEdge = ops.getNumberValue(map.get("Position"), 0).doubleValue();
        Iterator<T> iterator = ops.getStream(map.get("Nodes")).getOrThrow().iterator();
        trainMigration.locations = Couple.create(
            TrackNodeLocation.decode(ops, iterator.next(), dimensions),
            TrackNodeLocation.decode(ops, iterator.next(), dimensions)
        );
        return trainMigration;
    }

}
