package com.zurrtum.create.content.trains.graph;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation.DiscoveredLocation;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class TrackGraphHelper {

    @Nullable
    public static TrackGraphLocation getGraphLocationAt(class_1937 level, class_2338 pos, class_2352 targetDirection, class_243 targetAxis) {
        class_2680 trackBlockState = level.method_8320(pos);
        if (!(trackBlockState.method_26204() instanceof ITrackBlock track))
            return null;

        class_243 axis = targetAxis.method_1021(targetDirection.method_10181());
        double length = axis.method_1033();
        TrackGraph graph = null;

        // Case 1: Centre of block lies on a node

        TrackNodeLocation location = new TrackNodeLocation(class_243.method_24955(pos)
            .method_1031(0, track.getElevationAtCenter(level, pos, trackBlockState), 0)).in(level);
        graph = Create.RAILWAYS.sided(level).getGraph(location);
        if (graph != null) {
            TrackNode node = graph.locateNode(location);
            if (node != null) {
                Map<TrackNode, TrackEdge> connectionsFrom = graph.getConnectionsFrom(node);
                for (Map.Entry<TrackNode, TrackEdge> entry : connectionsFrom.entrySet()) {
                    TrackNode backNode = entry.getKey();
                    class_243 direction = entry.getValue().getDirection(true);
                    if (direction.method_1021(length).method_1025(axis.method_1021(-1)) > 1 / 4096f)
                        continue;

                    TrackGraphLocation graphLocation = new TrackGraphLocation();
                    graphLocation.edge = Couple.create(node.getLocation(), backNode.getLocation());
                    graphLocation.position = 0;
                    graphLocation.graph = graph;
                    return graphLocation;
                }
            }
        }

        // Case 2: Center of block is between two nodes

        Collection<DiscoveredLocation> ends = track.getConnected(level, pos, trackBlockState, true, null);
        class_243 start = class_243.method_24955(pos).method_1031(0, track.getElevationAtCenter(level, pos, trackBlockState), 0);

        TrackNode frontNode = null;
        TrackNode backNode = null;
        double position = 0;
        boolean singleTrackPiece = true;

        for (DiscoveredLocation current : ends) {
            class_243 offset = current.getLocation().method_1020(start).method_1029().method_1021(length);

            class_243 compareOffset = offset.method_18805(1, 0, 1).method_1029();
            boolean forward = compareOffset.method_1025(axis.method_18805(-1, 0, -1).method_1029()) < 1 / 4096f;
            boolean backwards = compareOffset.method_1025(axis.method_18805(1, 0, 1).method_1029()) < 1 / 4096f;

            if (!forward && !backwards)
                continue;

            DiscoveredLocation previous = null;
            double distance = 0;

            for (int i = 0; i < 100 && distance < 32; i++) {
                DiscoveredLocation loc = current;
                if (graph == null)
                    graph = Create.RAILWAYS.sided(level).getGraph(loc);

                if (graph == null || graph.locateNode(loc) == null) {
                    singleTrackPiece = false;
                    Collection<DiscoveredLocation> list = ITrackBlock.walkConnectedTracks(level, loc, true);
                    for (DiscoveredLocation discoveredLocation : list) {
                        if (discoveredLocation == previous)
                            continue;
                        class_243 diff = discoveredLocation.getLocation().method_1020(loc.getLocation());
                        if ((forward ? axis.method_1021(-1) : axis).method_1025(diff.method_1029().method_1021(length)) > 1 / 4096f)
                            continue;

                        previous = current;
                        current = discoveredLocation;
                        distance += diff.method_1033();
                        break;
                    }
                    continue;
                }

                TrackNode node = graph.locateNode(loc);
                if (forward)
                    frontNode = node;
                if (backwards) {
                    backNode = node;
                    position = distance + axis.method_1033() / 2;
                }
                break;
            }
        }

        if (frontNode == null || backNode == null)
            return null;

        if (singleTrackPiece)
            position = frontNode.getLocation().getLocation().method_1022(backNode.getLocation().getLocation()) / 2.0;

        TrackGraphLocation graphLocation = new TrackGraphLocation();
        graphLocation.edge = Couple.create(backNode.getLocation(), frontNode.getLocation());
        graphLocation.position = position;
        graphLocation.graph = graph;
        return graphLocation;
    }

    @Nullable
    public static TrackGraphLocation getBezierGraphLocationAt(
        class_1937 level,
        class_2338 pos,
        class_2352 targetDirection,
        BezierTrackPointLocation targetBezier
    ) {
        class_2680 state = level.method_8320(pos);

        if (!(state.method_26204() instanceof ITrackBlock track))
            return null;
        if (!(level.method_8321(pos) instanceof TrackBlockEntity trackBE))
            return null;
        BezierConnection bc = trackBE.getConnections().get(targetBezier.curveTarget());
        if (bc == null || !bc.isPrimary())
            return null;

        TrackNodeLocation targetLoc = new TrackNodeLocation(bc.starts.getSecond()).in(level);
        if (bc.smoothing != null)
            targetLoc.yOffsetPixels = bc.smoothing.getSecond();

        for (DiscoveredLocation location : track.getConnected(level, pos, state, true, null)) {
            TrackGraph graph = Create.RAILWAYS.sided(level).getGraph(location);
            if (graph == null)
                continue;
            TrackNode targetNode = graph.locateNode(targetLoc);
            if (targetNode == null)
                continue;
            TrackNode node = graph.locateNode(location);
            TrackEdge edge = graph.getConnectionsFrom(node).get(targetNode);
            if (edge == null)
                continue;

            TrackGraphLocation graphLocation = new TrackGraphLocation();
            graphLocation.graph = graph;
            graphLocation.edge = Couple.create(location, targetLoc);
            graphLocation.position = (targetBezier.segment() + 1) / 2f;
            if (targetDirection == class_2352.field_11056) {
                graphLocation.edge = graphLocation.edge.swap();
                graphLocation.position = edge.getLength() - graphLocation.position;
            }

            return graphLocation;
        }

        return null;
    }

}
