package com.zurrtum.create.content.trains.schedule;

import com.mojang.serialization.*;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ScheduleEntry {
    public static final class_9139<class_9129, ScheduleEntry> STREAM_CODEC = class_9139.method_56435(
        ScheduleInstruction.STREAM_CODEC,
        entry -> entry.instruction,
        CatnipStreamCodecBuilders.list(CatnipStreamCodecBuilders.list(ScheduleWaitCondition.STREAM_CODEC)),
        entry -> entry.conditions,
        ScheduleEntry::new
    );

    public ScheduleInstruction instruction;
    public List<List<ScheduleWaitCondition>> conditions;

    public ScheduleEntry() {
        conditions = new ArrayList<>();
    }

    public ScheduleEntry(ScheduleInstruction instruction, List<List<ScheduleWaitCondition>> conditions) {
        this.instruction = instruction;
        this.conditions = conditions;
    }

    public ScheduleEntry clone(class_7225.class_7874 registries) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleEntry", Create.LOGGER)) {
            class_11362 writeView = class_11362.method_71459(logging, registries);
            write(writeView);
            class_11368 readView = class_11352.method_71417(logging, registries, writeView.method_71475());
            return read(readView);
        }
    }

    public void write(class_11372 view) {
        instruction.write(view.method_71461("Instruction"));
        if (!instruction.supportsConditions())
            return;
        class_11372.class_11374 outer = view.method_71476("Conditions");
        conditions.forEach(column -> {
            class_11372.class_11374 list = outer.method_71480().method_71476("Column");
            column.forEach(condition -> {
                condition.write(list.method_71480());
            });
        });
    }

    public static <T> DataResult<T> encode(final ScheduleEntry input, final DynamicOps<T> ops, final T empty) {
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("Instruction", ScheduleInstruction.encode(input.instruction, ops, empty));
        if (!input.instruction.supportsConditions())
            return map.build(empty);
        ListBuilder<T> outer = ops.listBuilder();
        input.conditions.forEach(column -> {
            ListBuilder<T> list = ops.listBuilder();
            column.forEach(condition -> list.add(ScheduleWaitCondition.encode(condition, ops, empty)));
            outer.add(list.build(empty));
        });
        map.add("Conditions", outer.build(empty));
        return map.build(empty);
    }

    public static ScheduleEntry read(class_11368 view) {
        ScheduleEntry entry = new ScheduleEntry();
        entry.instruction = ScheduleInstruction.read(view.method_71434("Instruction"));
        entry.conditions = new ArrayList<>();
        if (entry.instruction.supportsConditions()) {
            view.method_71438("Conditions")
                .forEach(column -> entry.conditions.add(column.method_71438("Column").method_71447().map(ScheduleWaitCondition::read)
                    .collect(Collectors.toList())));
        }
        return entry;
    }

    public static <T> ScheduleEntry decode(DynamicOps<T> ops, T input) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        ScheduleEntry entry = new ScheduleEntry();
        entry.instruction = ScheduleInstruction.decode(ops, map.get("Instruction"));
        entry.conditions = new ArrayList<>();
        if (entry.instruction.supportsConditions()) {
            ops.getList(map.get("Conditions")).getOrThrow()
                .accept(column -> entry.conditions.add(ops.getStream(column).getOrThrow().map(item -> ScheduleWaitCondition.decode(ops, item))
                    .collect(Collectors.toList())));
        }
        return entry;
    }

}
