package com.zurrtum.create.content.trains.schedule;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.destination.DestinationInstruction;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.recipe.ItemCopyingRecipe.SupportsItemCopying;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9331;

public class ScheduleItem extends class_1792 implements MenuProvider, SupportsItemCopying {

    public ScheduleItem(class_1793 pProperties) {
        super(pProperties);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() == null)
            return class_1269.field_5811;
        return method_7836(context.method_8045(), context.method_8036(), context.method_20287());
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!player.method_5715() && hand == class_1268.field_5808) {
            if (!world.method_8608() && player instanceof class_3222 serverPlayer)
                openHandledScreen(serverPlayer);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 handScheduleTo(class_1799 pStack, class_1657 pPlayer, class_1309 pInteractionTarget, class_1268 pUsedHand) {
        class_1269 pass = class_1269.field_5811;

        Schedule schedule = getSchedule(pPlayer.method_56673(), pStack);
        if (schedule == null)
            return pass;
        if (pInteractionTarget == null)
            return pass;
        class_1297 rootVehicle = pInteractionTarget.method_5668();
        if (!(rootVehicle instanceof CarriageContraptionEntity entity))
            return pass;
        if (pPlayer.method_73183().method_8608())
            return class_1269.field_5812;

        Contraption contraption = entity.getContraption();
        if (contraption instanceof CarriageContraption cc) {

            Train train = entity.getCarriage().train;
            if (train == null)
                return class_1269.field_5812;

            Integer seatIndex = contraption.getSeatMapping().get(pInteractionTarget.method_5667());
            if (seatIndex == null)
                return class_1269.field_5812;
            class_2338 seatPos = contraption.getSeats().get(seatIndex);
            Couple<Boolean> directions = cc.conductorSeats.get(seatPos);
            if (directions == null) {
                pPlayer.method_7353(class_2561.method_43471("create.schedule.non_controlling_seat"), true);
                AllSoundEvents.DENY.playOnServer(pPlayer.method_73183(), pPlayer.method_24515(), 1, 1);
                return class_1269.field_5812;
            }

            if (train.runtime.getSchedule() != null) {
                AllSoundEvents.DENY.playOnServer(pPlayer.method_73183(), pPlayer.method_24515(), 1, 1);
                pPlayer.method_7353(class_2561.method_43471("create.schedule.remove_with_empty_hand"), true);
                return class_1269.field_5812;
            }

            if (schedule.entries.isEmpty()) {
                AllSoundEvents.DENY.playOnServer(pPlayer.method_73183(), pPlayer.method_24515(), 1, 1);
                pPlayer.method_7353(class_2561.method_43471("create.schedule.no_stops"), true);
                return class_1269.field_5812;
            }

            train.runtime.setSchedule(schedule, false);
            AllAdvancements.CONDUCTOR.trigger((class_3222) pPlayer);
            AllSoundEvents.CONFIRM.playOnServer(pPlayer.method_73183(), pPlayer.method_24515(), 1, 1);
            pPlayer.method_7353(class_2561.method_43471("create.schedule.applied_to_train").method_27692(class_124.field_1060), true);
            pStack.method_7934(1);
            pPlayer.method_6122(pUsedHand, pStack.method_7960() ? class_1799.field_8037 : pStack);
        }

        return class_1269.field_5812;
    }

    @Override
    public void method_67187(
        class_1799 stack,
        class_9635 context,
        class_10712 displayComponent,
        Consumer<class_2561> tooltip,
        class_1836 flagIn
    ) {
        Schedule schedule = getSchedule(context.method_59527(), stack);
        if (schedule == null || schedule.entries.isEmpty())
            return;

        class_5250 caret = class_2561.method_43470("> ").method_27692(class_124.field_1080);
        class_5250 arrow = class_2561.method_43470("-> ").method_27692(class_124.field_1080);

        List<ScheduleEntry> entries = schedule.entries;
        for (int i = 0; i < entries.size(); i++) {
            boolean current = i == schedule.savedProgress && schedule.entries.size() > 1;
            ScheduleEntry entry = entries.get(i);
            if (!(entry.instruction instanceof DestinationInstruction destination))
                continue;
            class_124 format = current ? class_124.field_1054 : class_124.field_1065;
            class_5250 prefix = current ? arrow : caret;
            tooltip.accept(prefix.method_27661().method_10852(class_2561.method_43470(destination.getFilter()).method_27692(format)));
        }
    }

    public static Schedule getSchedule(class_7225.class_7874 registries, class_1799 pStack) {
        if (!pStack.method_57826(AllDataComponents.TRAIN_SCHEDULE))
            return null;
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleItem", Create.LOGGER)) {
            class_11368 view = class_11352.method_71417(logging, registries, pStack.method_58694(AllDataComponents.TRAIN_SCHEDULE));
            return Schedule.read(view);
        }
    }

    @Override
    public ScheduleMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        class_1799 heldItem = player.method_6047();
        class_1799.field_48349.encode(extraData, heldItem);
        return new ScheduleMenu(id, inv, heldItem);
    }

    @Override
    public class_2561 getDisplayName() {
        return method_63680();
    }

    @Override
    public class_9331<?> getComponentType() {
        return AllDataComponents.TRAIN_SCHEDULE;
    }

}
