package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class FluidThresholdCondition extends CargoThresholdCondition {
    public FilterItemStack compareStack = FilterItemStack.empty();

    public FluidThresholdCondition(class_2960 id) {
        super(id);
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        Ops operator = getOperator();
        int target = getThreshold();

        int foundFluid = 0;
        for (Carriage carriage : train.carriages) {
            for (FluidStack fluidInTank : carriage.storage.getFluids()) {
                if (!compareStack.test(level, fluidInTank))
                    continue;
                foundFluid += fluidInTank.getAmount();
            }
        }

        requestStatusToUpdate(foundFluid / 81000, context);
        return operator.test(foundFluid, target * 81000);
    }

    @Override
    protected void writeAdditional(class_11372 view) {
        view.method_71468("Bucket", FilterItemStack.CODEC, compareStack);
    }

    @Override
    protected void readAdditional(class_11368 view) {
        super.readAdditional(view);
        view.method_71426("Bucket", FilterItemStack.CODEC).ifPresent(compareStack -> this.compareStack = compareStack);
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int lastDisplaySnapshot = getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1)
            return class_2561.method_43473();
        int offset = getOperator() == Ops.LESS ? -1 : getOperator() == Ops.GREATER ? 1 : 0;
        return class_2561.method_43469(
            "create.schedule.condition.threshold.status",
            lastDisplaySnapshot,
            Math.max(0, getThreshold() + offset),
            class_2561.method_43471("create.schedule.condition.threshold.buckets")
        );
    }
}
