package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class TimeOfDayCondition extends ScheduleWaitCondition {
    public TimeOfDayCondition(class_2960 id) {
        super(id);
        data.method_10569("Hour", 8);
        data.method_10569("Rotation", 5);
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        int maxTickDiff = 40;
        int targetHour = intData("Hour");
        int targetMinute = intData("Minute");
        int dayTime = (int) (level.method_8532() % getRotation());
        int targetTicks = (int) ((((targetHour + 18) % 24) * 1000 + Math.ceil(targetMinute / 60f * 1000)) % getRotation());
        int diff = dayTime - targetTicks;
        return diff >= 0 && maxTickDiff >= diff;
    }

    public int getRotation() {
        int index = intData("Rotation");
        return switch (index) {
            case 9 -> 250;
            case 8 -> 500;
            case 7 -> 750;
            case 6 -> 1000;
            case 5 -> 2000;
            case 4 -> 3000;
            case 3 -> 4000;
            case 2 -> 6000;
            case 1 -> 12000;
            default -> 24000;
        };
    }

    public class_5250 getDigitalDisplay(int hour, int minute, boolean doubleDigitHrs) {
        int hour12raw = hour % 12 == 0 ? 12 : hour % 12;
        String hr12 = doubleDigitHrs ? twoDigits(hour12raw) : ("" + hour12raw);
        String hr24 = doubleDigitHrs ? twoDigits(hour) : ("" + hour);
        return class_2561.method_43469(
            "create.schedule.condition.time_of_day.digital_format",
            hr12,
            hr24,
            twoDigits(minute),
            hour > 11 ? class_2561.method_43471("create.generic.daytime.pm") : class_2561.method_43471("create.generic.daytime.am")
        );
    }

    public String twoDigits(int t) {
        return t < 10 ? "0" + t : "" + t;
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int targetHour = intData("Hour");
        int targetMinute = intData("Minute");
        long timeOfDay = level.method_8532();
        int dayTime = (int) (timeOfDay % getRotation());
        int targetTicks = (int) ((((targetHour + 18) % 24) * 1000 + Math.ceil(targetMinute / 60f * 1000)) % getRotation());
        int diff = targetTicks - dayTime;

        if (diff < 0)
            diff += getRotation();

        int departureTime = (int) (timeOfDay + diff) % 24000;
        int departingHour = (departureTime / 1000 + 6) % 24;
        int departingMinute = (departureTime % 1000) * 60 / 1000;

        return class_2561.method_43471("create.schedule.condition.time_of_day.status")
            .method_10852(getDigitalDisplay(departingHour, departingMinute, false));
    }
}
