package com.zurrtum.create.content.trains.signal;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_8235;
import net.minecraft.class_9904;

public class SignalBlock extends class_2248 implements IBE<SignalBlockEntity>, IWrenchable, WeakPowerControlBlock {

    public static final class_2754<SignalType> TYPE = class_2754.method_11850("type", SignalType.class);
    public static final class_2746 POWERED = class_2741.field_12484;

    public enum SignalType implements class_3542 {
        ENTRY_SIGNAL,
        CROSS_SIGNAL;
        public static final Codec<SignalType> CODEC = class_3542.method_28140(SignalType::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public SignalBlock(class_2251 p_53182_) {
        super(p_53182_);
        method_9590(method_9564().method_11657(TYPE, SignalType.ENTRY_SIGNAL).method_11657(POWERED, false));
    }

    @Override
    public Class<SignalBlockEntity> getBlockEntityClass() {
        return SignalBlockEntity.class;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(TYPE, POWERED));
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return method_9564().method_11657(POWERED, pContext.method_8045().method_49803(pContext.method_8037()));
    }

    @Override
    public void method_9612(
        class_2680 pState,
        class_1937 pLevel,
        class_2338 pPos,
        class_2248 pBlock,
        @Nullable class_9904 wireOrientation,
        boolean pIsMoving
    ) {
        if (pLevel.method_8608())
            return;
        boolean powered = pState.method_11654(POWERED);
        if (powered == pLevel.method_49803(pPos))
            return;
        if (powered) {
            pLevel.method_64310(pPos, this, 4);
        } else {
            pLevel.method_8652(pPos, pState.method_28493(POWERED), class_2248.field_31028);
        }
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRand) {
        if (pState.method_11654(POWERED) && !pLevel.method_49803(pPos))
            pLevel.method_8652(pPos, pState.method_28493(POWERED), class_2248.field_31028);
    }

    @Override
    public class_2591<? extends SignalBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.TRACK_SIGNAL;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        if (level.method_8608())
            return class_1269.field_5812;
        withBlockEntityDo(
            level, pos, ste -> {
                SignalBoundary signal = ste.getSignal();
                class_1657 player = context.method_8036();
                if (signal != null) {
                    signal.cycleSignalType(pos);
                    if (player != null)
                        player.method_7353(
                            class_2561.method_43471("create.track_signal.mode_change." + signal.getTypeFor(pos).method_15434()), true);
                } else if (player != null)
                    player.method_7353(class_2561.method_43471("create.track_signal.cannot_change_mode"), true);
            }
        );
        return class_1269.field_5812;
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 blockAccess, class_2338 pPos, class_2350 direction) {
        return getBlockEntityOptional(blockAccess, pPos).filter(SignalBlockEntity::isPowered).map($ -> 15).orElse(0);
    }

}
