package com.zurrtum.create.content.trains.signal;

import com.mojang.serialization.*;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.*;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_4844;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import java.util.Iterator;
import java.util.UUID;

public abstract class TrackEdgePoint {

    public UUID id;
    public Couple<TrackNodeLocation> edgeLocation;
    public double position;
    private EdgePointType<?> type;

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return id;
    }

    public void setType(EdgePointType<?> type) {
        this.type = type;
    }

    public EdgePointType<?> getType() {
        return type;
    }

    public abstract boolean canMerge();

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return false;
    }

    public abstract void invalidate(class_1936 level);

    protected void invalidateAt(class_1936 level, class_2338 blockEntityPos) {
        TrackTargetingBehaviour<?> behaviour = BlockEntityBehaviour.get(level, blockEntityPos, TrackTargetingBehaviour.TYPE);
        if (behaviour == null)
            return;
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "TrackEdgePoint", Create.LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, level.method_30349());
            DimensionPalette dimensions = new DimensionPalette();
            write(view, dimensions);
            view.method_71468("DimensionPalette", DimensionPalette.CODEC, dimensions);
            behaviour.invalidateEdgePoint(view.method_71475());
        }
    }

    public abstract void blockEntityAdded(class_2586 blockEntity, boolean front);

    public abstract void blockEntityRemoved(MinecraftServer server, class_2338 blockEntityPos, boolean front);

    public void onRemoved(MinecraftServer server, TrackGraph graph) {
    }

    public void setLocation(Couple<TrackNodeLocation> nodes, double position) {
        this.edgeLocation = nodes;
        this.position = position;
    }

    public double getLocationOn(TrackEdge edge) {
        return isPrimary(edge.node1) ? edge.getLength() - position : position;
    }

    public boolean canNavigateVia(TrackNode side) {
        return true;
    }

    public boolean isPrimary(TrackNode node1) {
        return edgeLocation.getSecond().equals(node1.getLocation());
    }

    public void read(class_11368 view, boolean migration, DimensionPalette dimensions) {
        if (migration)
            return;

        id = view.method_71426("Id", class_4844.field_25122).orElseThrow();
        position = view.method_71422("Position", 0);
        Iterator<class_11368> edge = view.method_71438("Edge").iterator();
        edgeLocation = Couple.create(TrackNodeLocation.read(edge.next(), dimensions), TrackNodeLocation.read(edge.next(), dimensions));
    }

    public <T> void decode(final DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        if (migration)
            return;

        MapLike<T> map = ops.getMap(input).getOrThrow();
        id = class_4844.field_25122.decode(ops, map.get("Id")).getOrThrow().getFirst();
        position = ops.getNumberValue(map.get("Position"), 0).doubleValue();
        edgeLocation = Couple.create(null, null);
        ops.getList(map.get("Edge")).getOrThrow().accept(item -> {
            TrackNodeLocation location = TrackNodeLocation.decode(ops, item, dimensions);
            if (edgeLocation.getFirst() == null) {
                edgeLocation.setFirst(location);
            } else {
                edgeLocation.setSecond(location);
            }
        });
    }

    public void read(class_2540 buffer, DimensionPalette dimensions) {
        id = buffer.method_10790();
        edgeLocation = Couple.create(() -> TrackNodeLocation.receive(buffer, dimensions));
        position = buffer.readDouble();
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Id", class_4844.field_25122, id);
        view.method_71463("Position", position);
        class_11372.class_11374 edge = view.method_71476("Edge");
        edgeLocation.getFirst().write(edge.method_71480(), dimensions);
        edgeLocation.getSecond().write(edge.method_71480(), dimensions);
    }

    public <T> DataResult<T> encode(final DynamicOps<T> ops, final T empty, DimensionPalette dimensions) {
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("Id", id, class_4844.field_25122);
        map.add("Position", ops.createDouble(position));
        ListBuilder<T> edge = ops.listBuilder();
        edge.add(TrackNodeLocation.encode(edgeLocation.getFirst(), ops, empty, dimensions));
        edge.add(TrackNodeLocation.encode(edgeLocation.getSecond(), ops, empty, dimensions));
        map.add("Edge", edge.build(empty));
        return map.build(empty);
    }

    public void write(class_2540 buffer, DimensionPalette dimensions) {
        buffer.method_10812(type.getId());
        buffer.method_10797(id);
        edgeLocation.forEach(loc -> loc.send(buffer, dimensions));
        buffer.method_52940(position);
    }

    public void tick(MinecraftServer server, TrackGraph graph, boolean preTrains) {
    }

    protected void removeFromAllGraphs(MinecraftServer server) {
        for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values())
            if (trackGraph.removePoint(server, getType(), id) != null)
                return;
    }

}
