package com.zurrtum.create.content.trains.track;

import com.google.common.base.Predicates;
import com.zurrtum.create.*;
import com.zurrtum.create.api.contraption.train.PortalTrackProvider;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.decoration.girder.GirderBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation.DiscoveredLocation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10225;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6756;

public class TrackBlock extends class_2248 implements IBE<TrackBlockEntity>, IWrenchable, ITrackBlock, SpecialBlockItemRequirement, ProperWaterloggedBlock {

    public static final class_2754<TrackShape> SHAPE = class_2754.method_11850("shape", TrackShape.class);
    public static final class_2746 HAS_BE = class_2746.method_11825("turn");

    protected final TrackMaterial material;

    public TrackBlock(class_2251 p_49795_, TrackMaterial material) {
        super(p_49795_);
        method_9590(method_9564().method_11657(SHAPE, TrackShape.ZO).method_11657(HAS_BE, false).method_11657(WATERLOGGED, false));
        this.material = material;
    }

    public static TrackBlock andesite(class_2251 settings) {
        return new TrackBlock(settings, AllTrackMaterials.ANDESITE);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> p_49915_) {
        super.method_9515(p_49915_.method_11667(SHAPE, HAS_BE, WATERLOGGED));
    }

    //TODO
    //    @Override
    //    public @Nullable PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
    //        return PathType.RAIL;
    //    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return fluidState(state);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 stateForPlacement = withWater(super.method_9605(ctx), ctx);

        if (ctx.method_8036() == null)
            return stateForPlacement;

        class_243 lookAngle = ctx.method_8036().method_5720();
        lookAngle = lookAngle.method_18805(1, 0, 1);
        if (class_3532.method_20390(lookAngle.method_1033(), 0))
            lookAngle = VecHelper.rotate(new class_243(0, 0, 1), -ctx.method_8036().method_36454(), class_2351.field_11052);

        lookAngle = lookAngle.method_1029();

        TrackShape best = TrackShape.ZO;
        double bestValue = Float.MAX_VALUE;
        for (TrackShape shape : TrackShape.values()) {
            if (shape.isJunction() || shape.isPortal())
                continue;
            class_243 axis = shape.getAxes().getFirst();
            double distance = Math.min(axis.method_1025(lookAngle), axis.method_1029().method_1021(-1).method_1025(lookAngle));
            if (distance > bestValue)
                continue;
            bestValue = distance;
            best = shape;
        }

        class_1937 level = ctx.method_8045();
        class_243 bestAxis = best.getAxes().getFirst();
        if (bestAxis.method_1027() == 1)
            for (boolean neg : Iterate.trueAndFalse) {
                class_2338 offset = ctx.method_8037().method_10081(class_2338.method_49638(bestAxis.method_1021(neg ? -1 : 1)));

                if (level.method_8320(offset).method_26206(level, offset, class_2350.field_11036) && !level.method_8320(offset.method_10084())
                    .method_26206(level, offset, class_2350.field_11033)) {
                    if (best == TrackShape.XO)
                        best = neg ? TrackShape.AW : TrackShape.AE;
                    if (best == TrackShape.ZO)
                        best = neg ? TrackShape.AN : TrackShape.AS;
                }
            }

        return stateForPlacement.method_11657(SHAPE, best);
    }

    @Override
    public class_2680 method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        super.method_9576(pLevel, pPos, pState, pPlayer);
        if (pLevel.method_8608())
            return pState;
        if (!pPlayer.method_68878())
            return pState;
        withBlockEntityDo(
            pLevel, pPos, be -> {
                be.cancelDrops = true;
                be.removeInboundConnections(true);
            }
        );

        return pState;
    }

    @Override
    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (pOldState.method_27852(this)) {
            if (pState.method_11657(HAS_BE, true) == pOldState.method_11657(HAS_BE, true)) {
                return;
            }
            TrackPropagator.onRailRemoved(pLevel, pPos, pState);
        }
        if (pLevel.method_8608()) {
            return;
        }
        class_6756<class_2248> blockTicks = pLevel.method_8397();
        if (!blockTicks.method_8674(pPos, this))
            pLevel.method_64310(pPos, this, 1);
        updateGirders(pState, pLevel, pPos, blockTicks);
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        withBlockEntityDo(pLevel, pPos, TrackBlockEntity::validateConnections);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 p_60465_) {
        TrackPropagator.onRailAdded(level, pos, state);
        withBlockEntityDo(level, pos, tbe -> tbe.tilt.undoSmoothing());
        if (!state.method_11654(SHAPE).isPortal())
            connectToPortal(level, pos, state);
    }

    protected void connectToPortal(class_3218 level, class_2338 pos, class_2680 state) {
        TrackShape shape = state.method_11654(TrackBlock.SHAPE);
        class_2351 portalTest = shape == TrackShape.XO ? class_2351.field_11048 : shape == TrackShape.ZO ? class_2351.field_11051 : null;
        if (portalTest == null)
            return;

        boolean pop = false;
        String fail = null;
        class_2338 failPos = null;

        for (class_2350 d : Iterate.directionsInAxis(portalTest)) {
            class_2338 portalPos = pos.method_10093(d);
            class_2680 portalState = level.method_8320(portalPos);
            if (!PortalTrackProvider.isSupportedPortal(portalState))
                continue;

            pop = true;
            PortalTrackProvider.Exit otherSide = PortalTrackProvider.getOtherSide(level, new BlockFace(pos, d));
            if (otherSide == null) {
                fail = "missing";
                continue;
            }

            class_3218 otherLevel = otherSide.level();
            BlockFace otherTrack = otherSide.face();
            class_2338 otherTrackPos = otherTrack.getPos();
            class_2680 existing = otherLevel.method_8320(otherTrackPos);
            if (!existing.method_45474()) {
                fail = "blocked";
                failPos = otherTrackPos;
                continue;
            }

            level.method_8652(pos, state.method_11657(SHAPE, TrackShape.asPortal(d)).method_11657(HAS_BE, true), class_2248.field_31036);
            class_2586 be = level.method_8321(pos);
            if (be instanceof TrackBlockEntity tbe)
                tbe.bind(otherLevel.method_27983(), otherTrackPos);

            class_2680 otherState = ProperWaterloggedBlock.withWater(
                otherLevel,
                state.method_11657(SHAPE, TrackShape.asPortal(otherTrack.getFace())).method_11657(HAS_BE, true),
                otherTrackPos
            );
            otherLevel.method_8652(otherTrackPos, otherState, class_2248.field_31036);
            class_2586 otherBE = otherLevel.method_8321(otherTrackPos);
            if (otherBE instanceof TrackBlockEntity tbe)
                tbe.bind(level.method_27983(), pos);

            pop = false;
        }

        if (!pop)
            return;

        level.method_22352(pos, true);

        if (fail == null)
            return;
        class_1657 player = level.method_8604(pos.method_10263(), pos.method_10264(), pos.method_10260(), 10, Predicates.alwaysTrue());
        if (player == null)
            return;
        player.method_7353(
            class_2561.method_43470("<!> ").method_10852(class_2561.method_43471("create.portal_track.failed")).method_27692(class_124.field_1065), false);
        class_5250 component = failPos != null ? class_2561.method_43469(
            "create.portal_track." + fail,
            failPos.method_10263(),
            failPos.method_10264(),
            failPos.method_10260()
        ) : class_2561.method_43471("create.portal_track." + fail);
        player.method_7353(class_2561.method_43470(" - ").method_27692(class_124.field_1080).method_10852(component.method_54663(0xFFD3B4)), false);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 level,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(level, tickView, state, pCurrentPos);
        TrackShape shape = state.method_11654(SHAPE);
        if (!shape.isPortal())
            return state;

        for (class_2350 d : Iterate.horizontalDirections) {
            if (TrackShape.asPortal(d) != state.method_11654(SHAPE))
                continue;
            if (pDirection != d)
                continue;

            class_2338 portalPos = pCurrentPos.method_10093(d);
            class_2680 portalState = level.method_8320(portalPos);
            if (!PortalTrackProvider.isSupportedPortal(portalState))
                return class_2246.field_10124.method_9564();
        }

        return state;
    }

    @Override
    public int getYOffsetAt(class_1922 world, class_2338 pos, class_2680 state, class_243 end) {
        return getBlockEntityOptional(world, pos).map(tbe -> tbe.tilt.getYOffsetForAxisEnd(end)).orElse(0);
    }

    @Override
    public Collection<DiscoveredLocation> getConnected(
        class_1922 worldIn,
        class_2338 pos,
        class_2680 state,
        boolean linear,
        TrackNodeLocation connectedTo
    ) {
        Collection<DiscoveredLocation> list;
        class_1922 world = connectedTo != null && worldIn instanceof class_3218 sl ? sl.method_8503().method_3847(connectedTo.dimension) : worldIn;

        if (getTrackAxes(world, pos, state).size() > 1) {
            class_243 center = class_243.method_24955(pos).method_1031(0, getElevationAtCenter(world, pos, state), 0);
            TrackShape shape = state.method_11654(TrackBlock.SHAPE);
            list = new ArrayList<>();
            for (class_243 axis : getTrackAxes(world, pos, state))
                for (boolean fromCenter : Iterate.trueAndFalse)
                    ITrackBlock.addToListIfConnected(
                        connectedTo,
                        list,
                        (d, b) -> axis.method_1021(b ? 0 : fromCenter ? -d : d).method_1019(center),
                        b -> shape.getNormal(),
                        b -> world instanceof class_1937 l ? l.method_27983() : class_1937.field_25179,
                        v -> 0,
                        axis,
                        null,
                        (b, v) -> ITrackBlock.getMaterialSimple(world, v)
                    );
        } else
            list = ITrackBlock.super.getConnected(world, pos, state, linear, connectedTo);

        if (!state.method_11654(HAS_BE))
            return list;
        if (linear)
            return list;

        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof TrackBlockEntity trackBE))
            return list;

        Map<class_2338, BezierConnection> connections = trackBE.getConnections();
        connections.forEach((connectedPos, bc) -> ITrackBlock.addToListIfConnected(
            connectedTo,
            list,
            (d, b) -> d == 1 ? class_243.method_24954(bc.bePositions.get(b)) : bc.starts.get(b),
            bc.normals::get,
            b -> world instanceof class_1937 l ? l.method_27983() : class_1937.field_25179,
            bc::yOffsetAt,
            null,
            bc,
            (b, v) -> ITrackBlock.getMaterialSimple(world, v, bc.getMaterial())
        ));

        if (trackBE.boundLocation == null || !(world instanceof class_3218 level))
            return list;

        class_5321<class_1937> otherDim = trackBE.boundLocation.getFirst();
        class_3218 otherLevel = level.method_8503().method_3847(otherDim);
        if (otherLevel == null)
            return list;
        class_2338 boundPos = trackBE.boundLocation.getSecond();
        class_2680 boundState = otherLevel.method_8320(boundPos);
        if (!boundState.method_26164(AllBlockTags.TRACKS))
            return list;

        class_243 center = class_243.method_24955(pos).method_1031(0, getElevationAtCenter(world, pos, state), 0);
        class_243 boundCenter = class_243.method_24955(boundPos).method_1031(0, getElevationAtCenter(otherLevel, boundPos, boundState), 0);
        TrackShape shape = state.method_11654(TrackBlock.SHAPE);
        TrackShape boundShape = boundState.method_11654(TrackBlock.SHAPE);
        class_243 boundAxis = getTrackAxes(otherLevel, boundPos, boundState).getFirst();

        getTrackAxes(world, pos, state).forEach(axis -> {
            ITrackBlock.addToListIfConnected(
                connectedTo,
                list,
                (d, b) -> (b ? axis : boundAxis).method_1021(d).method_1019(b ? center : boundCenter),
                b -> (b ? shape : boundShape).getNormal(),
                b -> b ? level.method_27983() : otherLevel.method_27983(),
                v -> 0,
                axis,
                null,
                (b, v) -> ITrackBlock.getMaterialSimple(b ? level : otherLevel, v)
            );
        });

        return list;
    }

    //TODO if needed
    //    @Override
    //    public void randomDisplayTick(BlockState pState, World pLevel, BlockPos pPos, Random pRand) {
    //        if (!pState.get(SHAPE).isPortal())
    //            return;
    //        Vec3d v = Vec3d.of(pPos).subtract(.125f, 0, .125f);
    //        CubeParticleData data = new CubeParticleData(1, pRand.nextFloat(), 1, .0125f + .0625f * pRand.nextFloat(), 30, false);
    //        pLevel.addParticleClient(data, v.x + pRand.nextFloat() * 1.5f, v.y + .25f, v.z + pRand.nextFloat() * 1.5f, 0.0D, 0.04D, 0.0D);
    //    }

    @Override
    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        TrackPropagator.onRailRemoved(pLevel, pPos, pState);
        if (!pLevel.method_8608())
            updateGirders(pState, pLevel, pPos, pLevel.method_14196());
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (level.method_8608())
            return class_1269.field_5812;
        for (Map.Entry<class_2338, class_3341> entry : StationBlockEntity.assemblyAreas.get(level).entrySet()) {
            if (!entry.getValue().method_14662(pos))
                continue;
            if (level.method_8321(entry.getKey()) instanceof StationBlockEntity station)
                if (station.trackClicked(player, hand, this, state, pos))
                    return class_1269.field_5812;
        }

        return class_1269.field_52423;
    }

    private void updateGirders(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_6756<class_2248> blockTicks) {
        for (class_243 vec3 : getTrackAxes(pLevel, pPos, pState)) {
            if (vec3.method_1033() > 1 || vec3.field_1351 != 0)
                continue;
            for (int side : Iterate.positiveAndNegative) {
                class_2338 girderPos = pPos.method_10074().method_10081(class_2338.method_49637(vec3.field_1350 * side, 0, vec3.field_1352 * side));
                class_2680 girderState = pLevel.method_8320(girderPos);
                if (girderState.method_26204() instanceof GirderBlock girderBlock && !blockTicks.method_8674(girderPos, girderBlock))
                    pLevel.method_64310(girderPos, girderBlock, 1);
            }
        }
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 reader, class_2338 pos) {
        return reader.method_8320(pos.method_10074()).method_26204() != this;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 p_60556_, class_2338 p_60557_, class_3726 p_60558_) {
        return getFullShape(state);
    }

    @Override
    public class_265 method_9584(class_2680 state, class_1922 pLevel, class_2338 pPos) {
        return getFullShape(state);
    }

    private class_265 getFullShape(class_2680 state) {
        return switch (state.method_11654(SHAPE)) {
            case AE -> AllShapes.TRACK_ASC.get(class_2350.field_11034);
            case AW -> AllShapes.TRACK_ASC.get(class_2350.field_11039);
            case AN -> AllShapes.TRACK_ASC.get(class_2350.field_11043);
            case AS -> AllShapes.TRACK_ASC.get(class_2350.field_11035);
            case CR_D -> AllShapes.TRACK_CROSS_DIAG;
            case CR_NDX -> AllShapes.TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11035);
            case CR_NDZ -> AllShapes.TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11035);
            case CR_O -> AllShapes.TRACK_CROSS;
            case CR_PDX -> AllShapes.TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11034);
            case CR_PDZ -> AllShapes.TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11034);
            case ND -> AllShapes.TRACK_DIAG.get(class_2350.field_11035);
            case PD -> AllShapes.TRACK_DIAG.get(class_2350.field_11034);
            case XO -> AllShapes.TRACK_ORTHO.get(class_2350.field_11034);
            case ZO -> AllShapes.TRACK_ORTHO.get(class_2350.field_11035);
            case TE -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11034);
            case TW -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11039);
            case TS -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11035);
            case TN -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11043);
            default -> AllShapes.TRACK_FALLBACK;
        };
    }

    @Override
    public class_265 method_9549(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch (pState.method_11654(SHAPE)) {
            case AE, AW, AN, AS -> class_259.method_1073();
            default -> AllShapes.TRACK_COLLISION;
        };
    }

    @Override
    public class_2586 method_10123(class_2338 p_153215_, class_2680 state) {
        if (!state.method_11654(HAS_BE))
            return null;
        return AllBlockEntityTypes.TRACK.method_11032(p_153215_, state);
    }

    @Override
    public Class<TrackBlockEntity> getBlockEntityClass() {
        return TrackBlockEntity.class;
    }

    @Override
    public class_2591<? extends TrackBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.TRACK;
    }

    @Override
    public class_243 getUpNormal(class_1922 world, class_2338 pos, class_2680 state) {
        return state.method_11654(SHAPE).getNormal();
    }

    @Override
    public List<class_243> getTrackAxes(class_1922 world, class_2338 pos, class_2680 state) {
        return state.method_11654(SHAPE).getAxes();
    }

    @Override
    public class_243 getCurveStart(class_1922 world, class_2338 pos, class_2680 state, class_243 axis) {
        boolean vertical = axis.field_1351 != 0;
        return VecHelper.getCenterOf(pos).method_1031(0, (vertical ? 0 : -.5f), 0).method_1019(axis.method_1021(.5));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return class_1269.field_5812;
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        if (!level.method_8608() && !player.method_68878() && state.method_11654(HAS_BE)) {
            class_2586 blockEntity = level.method_8321(context.method_8037());
            if (blockEntity instanceof TrackBlockEntity trackBE) {
                trackBE.cancelDrops = true;
                trackBE.connections.values().forEach(bc -> bc.addItemsToPlayer(player));
            }
        }

        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public class_2680 overlay(class_1922 world, class_2338 pos, class_2680 existing, class_2680 placed) {
        if (placed.method_26204() != this)
            return existing;

        TrackShape existingShape = existing.method_11654(SHAPE);
        TrackShape placedShape = placed.method_11654(SHAPE);
        TrackShape combinedShape = null;

        for (boolean flip : Iterate.trueAndFalse) {
            TrackShape s1 = flip ? existingShape : placedShape;
            TrackShape s2 = flip ? placedShape : existingShape;
            if (s1 == TrackShape.XO && s2 == TrackShape.ZO)
                combinedShape = TrackShape.CR_O;
            if (s1 == TrackShape.PD && s2 == TrackShape.ND)
                combinedShape = TrackShape.CR_D;
            if (s1 == TrackShape.XO && s2 == TrackShape.PD)
                combinedShape = TrackShape.CR_PDX;
            if (s1 == TrackShape.ZO && s2 == TrackShape.PD)
                combinedShape = TrackShape.CR_PDZ;
            if (s1 == TrackShape.XO && s2 == TrackShape.ND)
                combinedShape = TrackShape.CR_NDX;
            if (s1 == TrackShape.ZO && s2 == TrackShape.ND)
                combinedShape = TrackShape.CR_NDZ;
        }

        if (combinedShape != null)
            existing = existing.method_11657(SHAPE, combinedShape);
        return existing;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 pRotation) {
        return state.method_11657(SHAPE, state.method_11654(SHAPE).rotate(pRotation));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 pMirror) {
        return state.method_11657(SHAPE, state.method_11654(SHAPE).mirror(pMirror));
    }

    @Override
    public class_2680 getBogeyAnchor(class_1922 world, class_2338 pos, class_2680 state) {
        return AllBlocks.SMALL_BOGEY.method_9564()
            .method_11657(class_2741.field_12529, state.method_11654(SHAPE) == TrackShape.XO ? class_2351.field_11048 : class_2351.field_11051);
    }

    @Override
    public boolean trackEquals(class_2680 state1, class_2680 state2) {
        return state1.method_26204() == this && state2.method_26204() == this && state1.method_11657(HAS_BE, false) == state2.method_11657(HAS_BE, false);
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        int sameTypeTrackAmount = 1;
        Object2IntMap<TrackMaterial> otherTrackAmounts = new Object2IntArrayMap<>();
        int girderAmount = 0;

        if (be instanceof TrackBlockEntity track) {
            for (BezierConnection bezierConnection : track.getConnections().values()) {
                if (!bezierConnection.isPrimary())
                    continue;
                TrackMaterial material = bezierConnection.getMaterial();
                if (material == getMaterial()) {
                    sameTypeTrackAmount += bezierConnection.getTrackItemCost();
                } else {
                    otherTrackAmounts.put(material, otherTrackAmounts.getOrDefault(material, 0) + 1);
                }
                girderAmount += bezierConnection.getGirderItemCost();
            }
        }

        List<class_1799> stacks = new ArrayList<>();
        while (sameTypeTrackAmount > 0) {
            stacks.add(new class_1799(state.method_26204(), Math.min(sameTypeTrackAmount, 64)));
            sameTypeTrackAmount -= 64;
        }
        for (TrackMaterial material : otherTrackAmounts.keySet()) {
            int amt = otherTrackAmounts.getOrDefault(material, 0);
            while (amt > 0) {
                stacks.add(new class_1799(material, Math.min(amt, 64)));
                amt -= 64;
            }
        }
        while (girderAmount > 0) {
            stacks.add(new class_1799(AllItems.METAL_GIRDER, Math.min(girderAmount, 64)));
            girderAmount -= 64;
        }

        return new ItemRequirement(ItemUseType.CONSUME, stacks);
    }

    @Override
    public TrackMaterial getMaterial() {
        return material;
    }
}
