package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.ConnectingFrom;
import com.zurrtum.create.infrastructure.config.AllConfigs;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;

public class TrackPlacement {
    public static class PlacementInfo {

        public PlacementInfo(TrackMaterial material) {
            this.trackMaterial = material;
        }

        public BezierConnection curve = null;
        public boolean valid = false;
        public int end1Extent = 0;
        public int end2Extent = 0;
        public String message = null;

        public int requiredTracks = 0;
        public boolean hasRequiredTracks = false;

        public int requiredPavement = 0;
        public boolean hasRequiredPavement = false;
        public final TrackMaterial trackMaterial;

        // for visualisation
        public class_243 end1;
        public class_243 end2;
        public class_243 normal1;
        public class_243 normal2;
        public class_243 axis1;
        public class_243 axis2;
        class_2338 pos1;
        class_2338 pos2;

        public PlacementInfo withMessage(String message) {
            this.message = "track." + message;
            return this;
        }

        public PlacementInfo tooJumbly() {
            curve = null;
            return this;
        }
    }

    public static PlacementInfo cached;

    public static class_2338 hoveringPos;
    public static boolean hoveringMaxed;
    static int hoveringAngle;
    static class_1799 lastItem;

    public static PlacementInfo tryConnect(
        class_1937 level,
        class_1657 player,
        class_2338 pos2,
        class_2680 state2,
        class_1799 stack,
        boolean girder,
        boolean maximiseTurn
    ) {
        class_243 lookVec = player.method_5720();
        int lookAngle = (int) (22.5 + AngleHelper.deg(class_3532.method_15349(lookVec.field_1350, lookVec.field_1352)) % 360) / 8;
        int maxLength = AllConfigs.server().trains.maxTrackPlacementLength.get();

        if (level.method_8608() && cached != null && pos2.equals(hoveringPos) && stack.equals(lastItem) && hoveringMaxed == maximiseTurn && lookAngle == hoveringAngle)
            return cached;

        PlacementInfo info = new PlacementInfo(TrackMaterial.fromItem(stack.method_7909()));
        hoveringMaxed = maximiseTurn;
        hoveringAngle = lookAngle;
        hoveringPos = pos2;
        lastItem = stack;
        cached = info;

        ITrackBlock track = (ITrackBlock) state2.method_26204();
        Pair<class_243, class_2352> nearestTrackAxis = track.getNearestTrackAxis(level, pos2, state2, lookVec);
        class_243 axis2 = nearestTrackAxis.getFirst().method_1021(nearestTrackAxis.getSecond() == class_2352.field_11056 ? -1 : 1);
        class_243 normal2 = track.getUpNormal(level, pos2, state2).method_1029();
        class_243 normedAxis2 = axis2.method_1029();
        class_243 end2 = track.getCurveStart(level, pos2, state2, axis2);

        ConnectingFrom connectingFrom = stack.method_58694(AllDataComponents.TRACK_CONNECTING_FROM);

        class_2338 pos1 = connectingFrom.pos();
        class_243 axis1 = connectingFrom.axis();
        class_243 normedAxis1 = axis1.method_1029();
        class_243 end1 = connectingFrom.end();
        class_243 normal1 = connectingFrom.normal();
        class_2680 state1 = level.method_8320(pos1);

        if (level.method_8608()) {
            info.end1 = end1;
            info.end2 = end2;
            info.normal1 = normal1;
            info.normal2 = normal2;
            info.axis1 = axis1;
            info.axis2 = axis2;
        }

        if (pos1.equals(pos2))
            return info.withMessage("second_point");
        if (pos1.method_10262(pos2) > maxLength * maxLength)
            return info.withMessage("too_far").tooJumbly();
        if (!state1.method_28498(TrackBlock.HAS_BE))
            return info.withMessage("original_missing");
        if (level.method_8321(pos2) instanceof TrackBlockEntity tbe && tbe.isTilted())
            return info.withMessage("turn_start");

        if (axis1.method_1026(end2.method_1020(end1)) < 0) {
            axis1 = axis1.method_1021(-1);
            normedAxis1 = normedAxis1.method_1021(-1);
            end1 = track.getCurveStart(level, pos1, state1, axis1);
            if (level.method_8608()) {
                info.end1 = end1;
                info.axis1 = axis1;
            }
        }

        double[] intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, class_2351.field_11052);
        boolean parallel = intersect == null;
        boolean skipCurve = false;

        if ((parallel && normedAxis1.method_1026(normedAxis2) > 0) || (!parallel && (intersect[0] < 0 || intersect[1] < 0))) {
            axis2 = axis2.method_1021(-1);
            normedAxis2 = normedAxis2.method_1021(-1);
            end2 = track.getCurveStart(level, pos2, state2, axis2);
            if (level.method_8608()) {
                info.end2 = end2;
                info.axis2 = axis2;
            }
        }

        class_243 cross2 = normedAxis2.method_1036(new class_243(0, 1, 0));

        double a1 = class_3532.method_15349(normedAxis2.field_1350, normedAxis2.field_1352);
        double a2 = class_3532.method_15349(normedAxis1.field_1350, normedAxis1.field_1352);
        double angle = a1 - a2;
        double ascend = end2.method_1020(end1).field_1351;
        double absAscend = Math.abs(ascend);
        boolean slope = !normal1.equals(normal2);

        if (level.method_8608()) {
            class_243 offset1 = axis1.method_1021(info.end1Extent);
            class_243 offset2 = axis2.method_1021(info.end2Extent);
            class_2338 targetPos1 = pos1.method_10081(class_2338.method_49638(offset1));
            class_2338 targetPos2 = pos2.method_10081(class_2338.method_49638(offset2));
            info.curve = new BezierConnection(
                Couple.create(targetPos1, targetPos2),
                Couple.create(end1.method_1019(offset1), end2.method_1019(offset2)),
                Couple.create(normedAxis1, normedAxis2),
                Couple.create(normal1, normal2),
                true,
                girder,
                TrackMaterial.fromItem(stack.method_7909())
            );
        }

        // S curve or Straight

        double dist = 0;

        if (parallel) {
            double[] sTest = VecHelper.intersect(end1, end2, normedAxis1, cross2, class_2351.field_11052);
            if (sTest != null) {
                double t = Math.abs(sTest[0]);
                double u = Math.abs(sTest[1]);

                skipCurve = class_3532.method_20390(u, 0);

                if (!skipCurve && sTest[0] < 0)
                    return info.withMessage("perpendicular").tooJumbly();

                if (skipCurve) {
                    dist = VecHelper.getCenterOf(pos1).method_1022(VecHelper.getCenterOf(pos2));
                    info.end1Extent = (int) Math.round((dist + 1) / axis1.method_1033());

                } else {
                    if (!class_3532.method_20390(ascend, 0) || normedAxis1.field_1351 != 0)
                        return info.withMessage("ascending_s_curve");

                    double targetT = u <= 1 ? 3 : u * 2;

                    if (t < targetT)
                        return info.withMessage("too_sharp");

                    // This is for standardising s curve sizes
                    if (t > targetT) {
                        int correction = (int) ((t - targetT) / axis1.method_1033());
                        info.end1Extent = maximiseTurn ? 0 : correction / 2 + (correction % 2);
                        info.end2Extent = maximiseTurn ? 0 : correction / 2;
                    }
                }
            }
        }

        // Slope

        if (slope) {
            if (!skipCurve)
                return info.withMessage("slope_turn");
            if (class_3532.method_20390(normal1.method_1026(normal2), 0))
                return info.withMessage("opposing_slopes");
            if ((axis1.field_1351 < 0 || axis2.field_1351 > 0) && ascend > 0)
                return info.withMessage("leave_slope_ascending");
            if ((axis1.field_1351 > 0 || axis2.field_1351 < 0) && ascend < 0)
                return info.withMessage("leave_slope_descending");

            skipCurve = false;
            info.end1Extent = 0;
            info.end2Extent = 0;

            class_2351 plane = class_3532.method_20390(axis1.field_1352, 0) ? class_2351.field_11048 : class_2351.field_11051;
            intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, plane);
            double dist1 = Math.abs(intersect[0] / axis1.method_1033());
            double dist2 = Math.abs(intersect[1] / axis2.method_1033());

            if (dist1 > dist2)
                info.end1Extent = (int) Math.round(dist1 - dist2);
            if (dist2 > dist1)
                info.end2Extent = (int) Math.round(dist2 - dist1);

            double turnSize = Math.min(dist1, dist2);
            if (intersect[0] < 0 || intersect[1] < 0)
                return info.withMessage("too_sharp").tooJumbly();
            if (turnSize < 2)
                return info.withMessage("too_sharp");

            // This is for standardising curve sizes
            if (turnSize > 2 && !maximiseTurn) {
                info.end1Extent += turnSize - 2;
                info.end2Extent += turnSize - 2;
                turnSize = 2;
            }
        }

        // Straight ascend

        if (skipCurve && !class_3532.method_20390(ascend, 0)) {
            int hDistance = info.end1Extent;
            if (axis1.field_1351 == 0 || !class_3532.method_20390(absAscend + 1, dist / axis1.method_1033())) {

                if (axis1.field_1351 != 0 && axis1.field_1351 == -axis2.field_1351)
                    return info.withMessage("ascending_s_curve");

                info.end1Extent = 0;
                double minHDistance = Math.max(absAscend < 4 ? absAscend * 4 : absAscend * 3, 6) / axis1.method_1033();
                if (hDistance < minHDistance)
                    return info.withMessage("too_steep");
                if (hDistance > minHDistance) {
                    int correction = (int) (hDistance - minHDistance);
                    info.end1Extent = maximiseTurn ? 0 : correction / 2 + (correction % 2);
                    info.end2Extent = maximiseTurn ? 0 : correction / 2;
                }

                skipCurve = false;
            }
        }

        // Turn

        if (!parallel) {
            float absAngle = Math.abs(AngleHelper.deg(angle));
            if (absAngle < 60 || absAngle > 300)
                return info.withMessage("turn_90").tooJumbly();

            intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, class_2351.field_11052);
            double dist1 = Math.abs(intersect[0]);
            double dist2 = Math.abs(intersect[1]);
            float ex1 = 0;
            float ex2 = 0;

            if (dist1 > dist2)
                ex1 = (float) ((dist1 - dist2) / axis1.method_1033());
            if (dist2 > dist1)
                ex2 = (float) ((dist2 - dist1) / axis2.method_1033());

            double turnSize = Math.min(dist1, dist2) - .1d;
            boolean ninety = (absAngle + .25f) % 90 < 1;

            if (intersect[0] < 0 || intersect[1] < 0)
                return info.withMessage("too_sharp").tooJumbly();

            double minTurnSize = ninety ? 7 : 3.25;
            double turnSizeToFitAscend = minTurnSize + (ninety ? Math.max(0, absAscend - 3) * 2f : Math.max(0, absAscend - 1.5f) * 1.5f);

            if (turnSize < minTurnSize)
                return info.withMessage("too_sharp");
            if (turnSize < turnSizeToFitAscend)
                return info.withMessage("too_steep");

            // This is for standardising curve sizes
            if (!maximiseTurn) {
                ex1 += (turnSize - turnSizeToFitAscend) / axis1.method_1033();
                ex2 += (turnSize - turnSizeToFitAscend) / axis2.method_1033();
            }
            info.end1Extent = class_3532.method_15375(ex1);
            info.end2Extent = class_3532.method_15375(ex2);
            turnSize = turnSizeToFitAscend;
        }

        class_243 offset1 = axis1.method_1021(info.end1Extent);
        class_243 offset2 = axis2.method_1021(info.end2Extent);
        class_2338 targetPos1 = pos1.method_10081(class_2338.method_49638(offset1));
        class_2338 targetPos2 = pos2.method_10081(class_2338.method_49638(offset2));

        info.curve = skipCurve ? null : new BezierConnection(
            Couple.create(targetPos1, targetPos2),
            Couple.create(end1.method_1019(offset1), end2.method_1019(offset2)),
            Couple.create(normedAxis1, normedAxis2),
            Couple.create(normal1, normal2),
            true,
            girder,
            TrackMaterial.fromItem(stack.method_7909())
        );

        info.valid = true;

        info.pos1 = pos1;
        info.pos2 = pos2;
        info.axis1 = axis1;
        info.axis2 = axis2;

        placeTracks(level, info, state1, state2, targetPos1, targetPos2, true);

        class_1799 offhandItem = player.method_6079().method_7972();
        boolean shouldPave = offhandItem.method_7909() instanceof class_1747 && !offhandItem.method_31573(AllItemTags.INVALID_FOR_TRACK_PAVING);
        if (shouldPave) {
            class_1747 paveItem = (class_1747) offhandItem.method_7909();
            paveTracks(level, info, paveItem, true);
            info.hasRequiredPavement = true;
        }

        info.hasRequiredTracks = true;

        if (!player.method_68878()) {
            for (boolean simulate : Iterate.trueAndFalse) {
                if (level.method_8608() && !simulate)
                    break;

                int tracks = info.requiredTracks;
                int pavement = info.requiredPavement;
                int foundTracks = 0;
                int foundPavement = 0;

                class_1661 inv = player.method_31548();
                class_2371<class_1799> main = inv.method_67533();
                for (int j = 0, end = class_1661.field_30638 + 1; j <= end; j++) {
                    int i = j;
                    boolean offhand = j == end;
                    if (j == class_1661.field_30638)
                        i = inv.method_67532();
                    else if (offhand)
                        i = 0;
                    else if (j == inv.method_67532())
                        continue;

                    class_1799 stackInSlot = offhand ? inv.method_5438(class_1661.field_30639) : main.get(i);
                    boolean isTrack = stackInSlot.method_31573(AllItemTags.TRACKS) && stackInSlot.method_31574(stack.method_7909());
                    if (!isTrack && (!shouldPave || offhandItem.method_7909() != stackInSlot.method_7909()))
                        continue;
                    if (isTrack ? foundTracks >= tracks : foundPavement >= pavement)
                        continue;

                    int count = stackInSlot.method_7947();

                    if (!simulate) {
                        int remainingItems = count - Math.min(isTrack ? tracks - foundTracks : pavement - foundPavement, count);
                        if (i == inv.method_67532())
                            stackInSlot.method_57381(AllDataComponents.TRACK_CONNECTING_FROM);
                        class_1799 newItem = stackInSlot.method_46651(remainingItems);
                        if (offhand)
                            player.method_6122(class_1268.field_5810, newItem);
                        else
                            inv.method_5447(i, newItem);
                    }

                    if (isTrack)
                        foundTracks += count;
                    else
                        foundPavement += count;
                }

                if (simulate) {
                    if (foundTracks < tracks) {
                        info.valid = false;
                        info.tooJumbly();
                        info.hasRequiredTracks = false;
                        return info.withMessage("not_enough_tracks");
                    }

                    if (foundPavement < pavement) {
                        info.valid = false;
                        info.tooJumbly();
                        info.hasRequiredPavement = false;
                        return info.withMessage("not_enough_pavement");
                    }
                }
            }
        }

        if (level.method_8608())
            return info;
        if (shouldPave) {
            class_1747 paveItem = (class_1747) offhandItem.method_7909();
            paveTracks(level, info, paveItem, false);
        }
        return placeTracks(level, info, state1, state2, targetPos1, targetPos2, false);
    }

    private static void paveTracks(class_1937 level, PlacementInfo info, class_1747 blockItem, boolean simulate) {
        class_2248 block = blockItem.method_7711();
        info.requiredPavement = 0;
        if (block == null || block instanceof class_2343 || block.method_9564().method_26220(level, info.pos1).method_1110())
            return;

        Set<class_2338> visited = new HashSet<>();

        for (boolean first : Iterate.trueAndFalse) {
            int extent = (first ? info.end1Extent : info.end2Extent) + (info.curve != null ? 1 : 0);
            class_243 axis = first ? info.axis1 : info.axis2;
            class_2338 pavePos = first ? info.pos1 : info.pos2;
            info.requiredPavement += TrackPaver.paveStraight(level, pavePos.method_10074(), axis, extent, block, simulate, visited);
        }

        if (info.curve != null)
            info.requiredPavement += TrackPaver.paveCurve(level, info.curve, block, simulate, visited);
    }

    private static PlacementInfo placeTracks(
        class_1937 level,
        PlacementInfo info,
        class_2680 state1,
        class_2680 state2,
        class_2338 targetPos1,
        class_2338 targetPos2,
        boolean simulate
    ) {
        info.requiredTracks = 0;

        for (boolean first : Iterate.trueAndFalse) {
            int extent = first ? info.end1Extent : info.end2Extent;
            class_243 axis = first ? info.axis1 : info.axis2;
            class_2338 pos = first ? info.pos1 : info.pos2;
            class_2680 state = first ? state1 : state2;
            if (state.method_28498(TrackBlock.HAS_BE) && !simulate)
                state = state.method_11657(TrackBlock.HAS_BE, false);

            switch (state.method_11654(TrackBlock.SHAPE)) {
                case TE, TW:
                    state = state.method_11657(TrackBlock.SHAPE, TrackShape.XO);
                    break;
                case TN, TS:
                    state = state.method_11657(TrackBlock.SHAPE, TrackShape.ZO);
                    break;
                default:
                    break;
            }

            for (int i = 0; i < (info.curve != null ? extent + 1 : extent); i++) {
                class_243 offset = axis.method_1021(i);
                class_2338 offsetPos = pos.method_10081(class_2338.method_49638(offset));
                class_2680 stateAtPos = level.method_8320(offsetPos);
                // copy over all shared properties from the shaped state to the correct track material block
                class_2680 toPlace = BlockHelper.copyProperties(state, info.trackMaterial.getBlock().method_9564());

                boolean canPlace = stateAtPos.method_45474() || stateAtPos.method_26164(class_3481.field_20339);
                if (canPlace)
                    info.requiredTracks++;
                if (simulate)
                    continue;

                if (stateAtPos.method_26204() instanceof ITrackBlock trackAtPos) {
                    toPlace = trackAtPos.overlay(level, offsetPos, stateAtPos, toPlace);
                    canPlace = true;
                }

                if (canPlace)
                    level.method_8652(offsetPos, ProperWaterloggedBlock.withWater(level, toPlace, offsetPos), class_2248.field_31036);
            }
        }

        if (info.curve == null)
            return info;

        if (!simulate) {
            class_2680 onto = info.trackMaterial.getBlock().method_9564();
            class_2680 stateAtPos = level.method_8320(targetPos1);
            level.method_8652(
                targetPos1, ProperWaterloggedBlock.withWater(
                    level,
                    (stateAtPos.method_26164(AllBlockTags.TRACKS) ? stateAtPos : BlockHelper.copyProperties(state1, onto)).method_11657(TrackBlock.HAS_BE, true),
                    targetPos1
                ), class_2248.field_31036
            );

            stateAtPos = level.method_8320(targetPos2);
            level.method_8652(
                targetPos2, ProperWaterloggedBlock.withWater(
                    level,
                    (stateAtPos.method_26164(AllBlockTags.TRACKS) ? stateAtPos : BlockHelper.copyProperties(state2, onto)).method_11657(TrackBlock.HAS_BE, true),
                    targetPos2
                ), class_2248.field_31036
            );
        }

        class_2586 te1 = level.method_8321(targetPos1);
        class_2586 te2 = level.method_8321(targetPos2);
        int requiredTracksForTurn = (info.curve.getSegmentCount() + 1) / 2;

        if (!(te1 instanceof TrackBlockEntity tte1) || !(te2 instanceof TrackBlockEntity tte2)) {
            info.requiredTracks += requiredTracksForTurn;
            return info;
        }

        if (!tte1.getConnections().containsKey(tte2.method_11016()))
            info.requiredTracks += requiredTracksForTurn;

        if (simulate)
            return info;

        tte1.addConnection(info.curve);
        tte2.addConnection(info.curve.secondary());
        tte1.tilt.tryApplySmoothing();
        tte2.tilt.tryApplySmoothing();
        return info;
    }
}
