package com.zurrtum.create.foundation.blockEntity;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.class_1937;
import net.minecraft.class_3499;

public class StructureEntityInfoIterator implements Iterator<class_3499.class_3502> {
    private final class_1937 world;
    private final List<EntityControlStructureProcessor> controls;
    private Iterator<class_3499.class_3502> iterator;
    private class_3499.class_3502 next;

    public StructureEntityInfoIterator(
        class_1937 world,
        List<EntityControlStructureProcessor> controls,
        Iterator<class_3499.class_3502> iterator
    ) {
        this.world = world;
        this.controls = controls;
        this.iterator = iterator;
    }

    private boolean test(class_3499.class_3502 info) {
        for (EntityControlStructureProcessor processor : controls) {
            if (processor.skip(world, info)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (next != null) {
            return true;
        }
        if (iterator == null) {
            return false;
        }
        while (iterator.hasNext()) {
            class_3499.class_3502 info = iterator.next();
            if (test(info)) {
                next = info;
                return true;
            }
        }
        iterator = null;
        return false;
    }

    @Override
    public class_3499.class_3502 next() {
        if (hasNext()) {
            class_3499.class_3502 result = next;
            next = null;
            return result;
        }
        throw new NoSuchElementException();
    }
}
