package com.zurrtum.create.foundation.blockEntity.behaviour;

import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_7225;

public interface ValueSettingsHandleBehaviour extends ClipboardCloneable {
    default boolean acceptsValueSettings() {
        return true;
    }

    default void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
    }

    default boolean mayInteract(class_1657 player) {
        return true;
    }

    default int netId() {
        return 0;
    }

    ValueSettings getValueSettings();

    default void setValueSettings(class_1657 player, ValueSettings valueSetting, boolean ctrlDown) {
    }

    default void playFeedbackSound(BlockEntityBehaviour<?> origin) {
        origin.getLevel().method_8396(null, origin.getPos(), class_3417.field_14667, class_3419.field_15245, 0.25f, 2f);
        origin.getLevel().method_8396(null, origin.getPos(), class_3417.field_18308.comp_349(), class_3419.field_15245, 0.03f, 1.125f);
    }

    @Override
    default String getClipboardKey() {
        return "Settings";
    }

    @Override
    default boolean canWrite(class_7225.class_7874 registries, class_2350 side) {
        return acceptsValueSettings();
    }

    @Override
    default boolean writeToClipboard(class_11372 view, class_2350 side) {
        if (!acceptsValueSettings())
            return false;
        ValueSettings valueSettings = getValueSettings();
        view.method_71465("Value", valueSettings.value());
        view.method_71465("Row", valueSettings.row());
        return true;
    }

    @Override
    default boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        if (!acceptsValueSettings())
            return false;
        Optional<Integer> row = view.method_71439("Row");
        if (row.isEmpty()) {
            return false;
        }
        Optional<Integer> value = view.method_71439("Value");
        if (value.isEmpty()) {
            return false;
        }
        if (simulate)
            return true;
        setValueSettings(player, new ValueSettings(row.get(), value.get()), false);
        return true;
    }
}
