package com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.content.kinetics.crank.ValveHandleBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class ServerValveScrollValueBehaviour extends ServerScrollValueBehaviour {
    public ServerValveScrollValueBehaviour(SmartBlockEntity be) {
        super(be);
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings valueSetting, boolean ctrlHeld) {
        int value = Math.max(1, valueSetting.value());
        if (!valueSetting.equals(getValueSettings()))
            playFeedbackSound(this);
        setValue(valueSetting.row() == 0 ? -value : value);
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(value < 0 ? 0 : 1, Math.abs(value));
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        if (getLevel().method_8608())
            return;
        class_2680 blockState = blockEntity.method_11010();
        if (blockState.method_26204() instanceof ValveHandleBlock vhb)
            vhb.clicked(getLevel(), getPos(), blockState, player, hand);
    }
}
